package latexDraw.parsers.svg.elements;

import java.awt.geom.Point2D;
import java.text.ParseException;
import java.util.Vector;

import latexDraw.parsers.svg.MalformedSVGDocument;
import latexDraw.parsers.svg.SVGAttributes;
import latexDraw.parsers.svg.SVGDocument;
import latexDraw.parsers.svg.parsers.SVGPointsParser;

import org.w3c.dom.Node;

/**
 * Defines a model for shapes that have the <code>points</code> SVG attribute.<br>
 *<br>
 * This file is part of LaTeXDraw.<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 *<br>
 * 09/11/07<br>
 * @author Arnaud BLOUIN<br>
 * @version 0.1<br>
 * @since 0.1
 */
public abstract class AbstractPointsElement extends SVGElement
{
	/** The points of the element. @since 2.0.3 */
	protected Vector<Point2D> points;
	
	
	public AbstractPointsElement(Node n, SVGElement p) throws MalformedSVGDocument, ParseException
	{
		super(n, p);
		
		parsePoints();
	}
	
	
	/**
	 * Parses the points of the element.
	 * @throws ParseException If the format of the points is not valid.
	 * @since 2.0.3
	 */
	public void parsePoints() throws ParseException
	{
		SVGPointsParser parser = new SVGPointsParser(getPoints());
		parser.parse();
		points = parser.getPoints();
	}
	
	
	
	
	public AbstractPointsElement(SVGDocument doc)
	{
		super(doc);
		
		try { setPoints("0,0 1,1"); }//$NON-NLS-1$
		catch(ParseException e) { e.printStackTrace(); }
	}



	@Override
	public boolean checkAttributes()
	{
		return getPoints()!=null;
	}
	
	
	/**
	 * Parses and sets the points to the element.
	 * @throws ParseException If the format of the points is not valid.
	 * @since 2.0.3
	 */
	public void setPoints(String points) throws ParseException
	{
		if(points!=null) {
			setAttribute(SVGAttributes.SVG_POINTS, points);
			parsePoints();
		}
	}
	
	
	
	/**
	 * @return The points that make up the shape.
	 * @since 0.1
	 */
	public String getPoints()
	{
		return getAttribute(getUsablePrefix()+SVGAttributes.SVG_POINTS);
	}

	
	
	/**
	 * @return The set of points in the Point2D format or null if the format of <code>points</code> is not valid.
	 * @since 0.1
	 */
	public Vector<Point2D> getPoints2D()
	{
		return points;
	}
}
