/***************************************************************************
 *   Copyright (C) 2005 - 2006 by Christian Muehlhaeuser, Last.fm Ltd.     *
 *   chris@last.fm                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#include <QtCore>

#include "coverloader.h"

#include "ui_searchresultdialog.h"

class QStandardItemModel;

class ImageReceiver : public CoverLoader
{
    Q_OBJECT

    public:
        ImageReceiver( QUrl url );

    private:
        QBuffer *m_coverBuffer;

    signals:
        void imageReceived();

    private slots:
        void coverLoaded( bool error );
};

class ExtendedInfoDelegate : public QAbstractItemDelegate
{
    Q_OBJECT

    public:
        ExtendedInfoDelegate( QObject *parent = 0 );

        void paint( QPainter * painter, const QStyleOptionViewItem & option, const QModelIndex & index ) const;
        QSize sizeHint ( const QStyleOptionViewItem & option, const QModelIndex & index ) const;
};

class SearchResultDialog : public QDialog
{
    Q_OBJECT

    public:
        SearchResultDialog( QWidget *parent, int mode, QString searchToken );

        void search( int mode, QString searchToken );

    private:
        Ui::SearchResultDialog ui;

        QMovie *m_animation;
        QStandardItemModel *m_bestResultModel;
        QStandardItemModel *m_suggestionModel;
        int m_mode;
        QString m_searchToken;

    private slots:
        void searchArtistResult( const QString &artist, const QString& image, bool streamable, const QStringList &result, const QStringList& resultImages );
        void searchTagResult( const QStringList &result, const QList<QStringList> &topArtistList );

        void doubleClicked ( const QModelIndex & index );

        void searchResultStation();
};

