/* Copyright (c) 2000 Lars Bernhardsson, see README for licence details */

/*
 * Minimal clock app for larswm. No fork()/exec() is done, it updates
 * the status bar by setting the LARSWM_BARTEXT atom every second.
 */

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <time.h>

#include <X11/X.h>
#include <X11/Xos.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>


int main(int argc, char **argv)
{
	int i;
	time_t t;
	char *slist;
	char *display_string = "";
	Display *dpy;
	Atom bartext_larswm;
	XTextProperty pr;

	for (i = 1; i < argc; i++)
	{
		if (strcmp(argv[i], "-display") == 0 && i+1<argc)
		{
			display_string = argv[++i];
		}
		else
		{
			fprintf(stderr, "usage: smallclock [-display display]\n");
			exit(1);
		}
	}

	dpy = XOpenDisplay(display_string);

	if (dpy == 0)
	{
		perror ("XOpenDisplay");
		exit(1);
	}

	bartext_larswm = XInternAtom(dpy, "LARSWM_BARTEXT", False);

	while (1)
	{
		time (&t);
		slist = ctime (&t);
		slist[19] = '\0';

		XStringListToTextProperty (&slist, 1, &pr);
		XSetTextProperty (dpy, DefaultRootWindow (dpy), &pr, bartext_larswm);
		XSync(dpy, False);

		sleep (1);
	}
}
