/* -*-C-*-

$Id: linkup.c,v 1.3 2001/03/12 18:43:34 cph Exp $

Copyright (c) 2000-2001 Massachusetts Institute of Technology

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or (at
your option) any later version.

This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
02111-1307, USA.  */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <net/if.h>

typedef unsigned short u16;

#ifndef SIOCGMIIPHY
#define SIOCGMIIPHY (SIOCDEVPRIVATE)		/* Get the PHY in use. */
#define SIOCGMIIREG (SIOCDEVPRIVATE+1) 		/* Read a PHY register. */
#endif

int
main (int argc, const char ** argv)
{
  const char * ifname;
  int option_verbose = 0;
  int fd;
  struct ifreq ifr;
  int up_p;
  int running_p;
  int connected_p;

  /* Choose the interface name. */
  if (argc == 2)
    ifname = (argv[1]);
  else if ((argc == 3) && ((strcmp ((argv[1]), "-v")) == 0))
    {
      ifname = (argv[2]);
      option_verbose = 1;
    }
  else
    {
      fprintf (stderr, "usage: %s [-v] <interface>\n", (argv[0]));
      return (-1);
    }

  /* Open a basic socket. */
  fd = (socket (AF_INET, SOCK_DGRAM,0));
  if (fd < 0)
    {
      perror ("socket");
      return (-1);
    }

  /* Get the vitals from the interface. */
  strncpy ((ifr.ifr_name), ifname, IFNAMSIZ);
  if ((ioctl (fd, SIOCGIFFLAGS, (&ifr))) < 0)
    {
      fprintf (stderr, "SIOCGIFFLAGS on %s failed: %s\n", ifname,
	       (strerror (errno)));
      if (option_verbose)
	printf ("unknown\n");
      close (fd);
      return (-1);
    }
  up_p = (((ifr . ifr_flags) & IFF_UP) != 0);
  running_p = (((ifr . ifr_flags) & IFF_RUNNING) != 0);

  if ((ioctl (fd, SIOCGMIIPHY, (&ifr))) < 0)
    {
      fprintf (stderr, "SIOCGMIIPHY on %s failed: %s\n", ifname,
	       (strerror (errno)));
      close (fd);
      if (option_verbose)
	printf ("unknown\n");
      return (-1);
    }

  /* Check the link status. */
  {
    u16 * data = ((u16 *) (& (ifr.ifr_data)));
    (data[1]) = 1;
    if ((ioctl (fd, SIOCGMIIREG, (&ifr))) < 0)
      {
	fprintf (stderr, "SIOCGMIIREG on %s failed: %s\n", ifname,
		 (strerror (errno)));
	close (fd);
	if (option_verbose)
	  printf ("unknown\n");
	return (-1);
      }
    connected_p = (((data[3]) & 0x0016) == 0x0004);
  }
  close (fd);
  if (option_verbose)
    printf
      ("%s,%s,%s\n",
       (up_p ? "up" : "down"),
       (running_p ? "running" : "stopped"),
       (connected_p ? "connected" : "disconnected"));
  return (!connected_p);
}
