#
#
#   user-ja-conf
#
#   This file is a part of the Debian user-ja package.
#
#
# Copyright (C) 1998-2002 Tomohiro KUBOTA
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# On Debian GNU/Linux systems, the complete text of the GNU General
# Public License can be found in `/usr/share/common-licenses/GPL'.
#
#
#
#
# These sub-routines are to be used by dot.*.pl.
#
# ------------------------------------------------
# isinstalled() checks whether a package is 
# installed or not.
# ------------------------------------------------
sub isinstalled ($) {
	my $a;
	$a = $_[0];
	if (grep(/^$a$/,@::DPKG_LIST)) {return 1;}
	return 0;
}

# ------------------------------------------------
# addlist() adds a package name to a 
# required package list
# ------------------------------------------------
sub addlist ($) {
	my $a;
	$a = $_[0];
	if (isinstalled($a)) {return 0;}
	if (grep($_ eq $a, @::RequiredPackageList)) {return 0;}
	@::RequiredPackageList = (@::RequiredPackageList , $a);
	return 0;
}

# ------------------------------------------------
# disp() displays a message suitable for native
# character environment.
# The 1st parameter is a message written in ASCII.
# The 2nd parameter is a message written in local
# codeset for source code.
# ------------------------------------------------
sub disp ($$) {
	if ($NC) {print STDERR &$::Lang_sourceset2displayset($_[1]);}
	else {print STDERR $_[0];}
}

# ------------------------------------------------
# This is used only internally.
# ------------------------------------------------
sub yesno_ ($$$) {
	my ($a, $disp1, $disp2);
	$disp1 = $_[0]; $disp2 = $_[1];
	chomp($disp1);
	chomp($disp2);
	&disp($disp1, $disp2);
	if ($_[2]) {
		print STDERR " [$Lang::yes_upper/$Lang::no_lower] ";
	} else {
		print STDERR " [$Lang::yes_lower/$Lang::no_upper] ";
	}
	$a = <STDIN>; chomp($a);
	if ($a eq $Lang::yes_upper || $a eq $Lang::yes_lower) {return 1;}
	if ($a eq  $Lang::no_upper || $a eq  $Lang::no_lower) {return 0;}
	return $_[2];
}

# ------------------------------------------------
# select 1,2,...,$_[2] and return the number
# or $_[3] for out value.
# ------------------------------------------------
sub select ($$$$) {
	my $a;
	&disp($_[0],$_[1]);
	print STDERR " (1..$_[2], [Enter]=$_[3]) ";
	$a = <STDIN>; chomp($a);
	if ($a >= 1 && $a <= $_[2]) {return $a;}
	$_[3];
}

# ------------------------------------------------
# Reply yes or no. Default is Yes.
# ------------------------------------------------
sub yesno ($$) {
	&yesno_ ($_[0], $_[1], 1);
}

# ------------------------------------------------
# Reply yes or no. Default is No.
# ------------------------------------------------
sub noyes ($$) {
	&yesno_ ($_[0], $_[1], 0);
}

# ------------------------------------------------
# Reply string and return.
# ------------------------------------------------
sub ask ($$) {
	my $a;
	&disp($_[0], $_[1]);
	$a = <STDIN>; chomp($a);
	return $a;
}
