/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *
 *	$Id: tsetbuf.c,v 6.3 1999/05/27 20:07:09 kmeyer1 Exp $
 * 
 *	We are just putting our stamp on this for housekeeping reasons.
 */

/*
 * This file is originally from dLibs 1.2 by Dale Schumacher et al.
 * It was modified for Trollius by MB, 88/12.
 * It was modified again for portability by GDB, 91/08.
 * And yet again by JRV for LAM, 93/05.
 */

#include <tstdio.h>

void
tsetbuffer(fp, buf, size)
	TFILE *fp;
	unsigned char *buf;
	int size;
{
	if (! (fp->_flag & (_TIOREAD | _TIOWRT))) return;
	fp->_cnt = 0;
	fp->_ptr = buf;
	if ((fp->_base = buf))		/* assignment intentional */
	{
		fp->_bsiz = size;
	}
	else
	{
		fp->_flag &= ~(_TIOFBF | _TIOLBF | _TIONBF | _TIOMYBUF);
		fp->_flag |= _TIONBF;
		fp->_bsiz = 0;
	}
}

void
tsetbuf(fp, buf)

TFILE		*fp;
unsigned char	*buf;

{
	tsetbuffer(fp, buf, TBUFSIZ);
}

int
tsetvbuf(fp, buf, type, size)

TFILE		*fp;
unsigned char	*buf;
int		type;
int		size;

{
	if (! (fp->_flag & (_TIOREAD | _TIOWRT))) {
		return(EOF);
	}

	if ((type != _TIOFBF) || (type != _TIOLBF) || (type != _TIONBF)) {
		return(EOF);
	}

	fp->_flag &= ~(_TIOFBF | _TIOLBF | _TIONBF);
	fp->_flag |= type;

	if (buf) {

		if (size <= 0) {
			return(EOF);
		}

		fp->_base = buf;
		fp->_ptr = buf;
		fp->_bsiz = size;
		fp->_cnt = 0;
	}

	return(0);
}

int
tsetlinebuf(fp)

TFILE		*fp;

{
	if (! (fp->_flag & (_TIOREAD | _TIOWRT))) {
		return(EOF);
	}

	fp->_flag &= ~(_TIOFBF | _TIOLBF | _TIONBF);
	fp->_flag |= _TIOLBF;
	return(0);
}
