/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	NJN
 *
 *	$Id: portclose.c,v 6.5 2001/01/30 18:25:32 jsquyres Exp $
 *
 *	Function:	- close an MPI port
 *	Accepts:	- port name
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <string.h>

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <terror.h>


/*@
   MPI_Close_port - Close a server port

Input Parameters:
. port_name - port name

.N fortran

.N IMPI_MPI2

.N Errors
.N MPI_ERR_ARG
.N MPI_ERR_OTHER
.N MPI_ERR_INTERN

.seealso MPI_Comm_accept(3), MPI_Comm_connect(3), MPI_Comm_disconnect(3), MPI_Open_port(3)

.N WEB
@*/
int
MPI_Close_port(char *port_name)
{
	struct _port	search;			/* search key for port */
	struct _port	*port;			/* found port */

	lam_initerr();
	lam_setfunc(BLKMPICLOSEPORT);

	if (strlen(port_name) > LAM_PORTLEN) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPICLOSEPORT,
					lam_mkerr(MPI_ERR_ARG, 0)));
	}
/*
 * Find the port.
 */
	strncpy(search.prt_name, port_name, LAM_PORTLEN);

	port = al_find(lam_ports, &search);
	if (port == 0) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPICLOSEPORT,
					lam_mkerr(MPI_ERR_OTHER, ENOENT)));
	}
/*
 * close it
 */
	if (lam_port_close(port->prt_num)) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPICLOSEPORT,
					lam_mkerr(MPI_ERR_OTHER, errno)));
	}
	if (al_delete(lam_ports, port)) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPICLOSEPORT,
					lam_mkerr(MPI_ERR_INTERN, 0)));
	}

        lam_resetfunc(BLKMPICLOSEPORT);
	return(MPI_SUCCESS);
}
