/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: errfree.c,v 6.6 1999/12/31 21:27:22 jsquyres Exp $
 *
 *	Function:	- free error handler
 *	Accepts:	- ptr error handler
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <stdlib.h>

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <MPISYSF.h>

/*@
  MPI_Errhandler_free - Frees an MPI-style errorhandler

Input Parameter:
. errhandler - MPI error handler (handle).  Set to 'MPI_ERRHANDLER_NULL' on 
exit.

.N fortran

.N Errors
.N MPI_SUCCESS
.N MPI_ERR_ARG

.N ACK
@*/
int MPI_Errhandler_free(MPI_Errhandler* errhdl)
{
	lam_initerr_m();
	lam_setfunc_m(BLKMPIERRFREE);
/*
 * Check the arguments.
 */
	if (errhdl == 0 || *errhdl == MPI_ERRHANDLER_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIERRFREE, lam_mkerr(MPI_ERR_ARG, 0)));
	}
/*
 * Only internal library calls can free predefined handlers.
 */
	if (lam_numfuncs() == 1 && (*errhdl == MPI_ERRORS_ARE_FATAL
			|| *errhdl == MPI_ERRORS_RETURN)) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIERRFREE, lam_mkerr(MPI_ERR_ARG, 0)));
	}
/*
 * Free the handler.
 */
	if (--((*errhdl)->eh_refcount) == 0) {

		if (*errhdl == MPI_ERRORS_ARE_FATAL
				|| *errhdl == MPI_ERRORS_RETURN) {
			return(lam_errfunc(MPI_COMM_WORLD,
				BLKMPIERRFREE, lam_mkerr(MPI_ERR_INTERN, 0)));
		}

		if ((*errhdl)->eh_f77handle >= 0) {
			lam_F_free_hdl((*errhdl)->eh_f77handle);
		}

		free((char *) *errhdl);
	}

	*errhdl = MPI_ERRHANDLER_NULL;

	lam_resetfunc_m(BLKMPIERRFREE);
	return(MPI_SUCCESS);
}
