/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	GDB
 *
 *	$Id: stoi.c,v 6.3 1999/05/24 16:56:51 kmeyer1 Exp $
 *
 *	Function:	- convert decimal or hexadecimal string to integer
 */

#include "lam.h"

int4
stoi(s)

unsigned char		*s;

{
	int4  		base;			/* base of digits */
	int4  		i;			/* result */
	int4  		sign;			/* sign of result */
	int		valid;			/* valid digit? */
	unsigned char	c;			/* current digit */

	if (s[0] == '-') {
		sign = -1;
		s++;
	} else {
		sign = 1;
	}

	if ((s[0] == '0') && ((s[1] == 'x') || (s[1] == 'X'))) {
		base = 16;
		s += 2;
	} else {
		base = 10;
	}

	i = 0;
	valid = 1;

	while (*s && valid) {
		c = *s;

		if ((c >= '0') && (c <= '9')) {
			i = (i * base) + (c - '0');
		}

		else if (base == 16) {

			if ((c >= 'a') && (c <= 'f')) {
				i = (i * base) + (c - 'a' + 0xa);
			}

			else if ((c >= 'A') && (c <= 'F')) {
				i = (i * base) + (c - 'A' + 0xA);
			}

			else {
				valid = 0;
			}
		} else {
			valid = 0;
		}

		s++;
	}

	i *= sign;

	return(i);
}
