/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	RBD
 *
 *	$Id: bsendinit.c,v 6.11 1999/11/12 05:19:28 jsquyres Exp $
 *
 *	Function:	- create a buffered send request
 *	Accepts:	- buffer
 *			- count
 *			- datatype
 *			- destination
 *			- tag
 *			- communicator
 *			- request (returned)
 *	Returns: 	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <rpisys.h>
#if LAM_WANT_IMPI
#include <impi.h>
#include <debug.h>
#endif

/*
 * external functions
 */
extern int		lam_errfunc();
extern void		lam_initerr();
extern void		lam_resetfunc();
extern void		lam_setfunc();
extern int		_mpi_req_build();


int
MPI_Bsend_init(buf, count, dtype, dest, tag, comm, req)

void			*buf;
int			count;
MPI_Datatype		dtype;
int			dest;
int			tag;
MPI_Comm		comm;
MPI_Request		*req;

{
	int		err;			/* error code */
#if LAM_WANT_IMPI
	MPI_Request     lreq;
#endif
	
	lam_initerr_m();
	lam_setfunc_m(BLKMPIBSINIT);

	if (tag < 0 || tag > LAM_MAXTAG) {
		return(lam_errfunc(comm, BLKMPIBSINIT,
				lam_mkerr(MPI_ERR_TAG, 0)));
	}

	if (dest == MPI_ANY_SOURCE) {
		return(lam_errfunc(comm, BLKMPIBSINIT,
				lam_mkerr(MPI_ERR_RANK, 0)));
	}

#if LAM_WANT_IMPI
	/* If IMPI_Isend_lamgiappe returns != MPI_REQUEST_NULL, this
           is an IMPI proxy send.  Need to re-route to the impid.  */

	IMPI_Isend_lamgiappe_init(LAM_RQISEND, count, dtype, dest, tag, 
				  comm, &lreq);
	if (lreq != MPI_REQUEST_NULL) {
	  dest = impid_comm->c_group->g_nprocs - 1;
	  tag  = IMPI_MESSAGE_TAG;
	  comm = impid_comm;
	}
#endif
	
/*
 * Create the fake user request.
 */
	*req = MPI_REQUEST_NULL;
	err = _mpi_req_build(buf, count, dtype, dest, tag, comm,
				LAM_RQIFAKE, req);

	if (err != MPI_SUCCESS) {
		return(lam_errfunc(comm, BLKMPIBSINIT, err));
	}

	(*req)->rq_marks |= (LAM_RQFPERSIST | LAM_RQFMAND);
	(*req)->rq_status.MPI_ERROR = MPI_SUCCESS;
	(*req)->rq_status.MPI_TAG = MPI_UNDEFINED;
	(*req)->rq_status.MPI_SOURCE = MPI_PROC_NULL;
#if LAM_WANT_IMPI
	(*req)->rq_shadow = lreq;
#endif

	lam_resetfunc_m(BLKMPIBSINIT);
	return(MPI_SUCCESS);
}
