(* Copyright (C) 2000, Luca Padovani <luca.padovani@cs.unibo.it>.
 *
 * This file is part of lablgtkmathview, the Ocaml binding
 * for the GtkMathView widget.
 * 
 * lablgtkmathview is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * lablgtkmathview is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with lablgtkmathview; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * For details, send a mail to the author.
 *)

exception ErrorLoadingFile of string
exception ErrorWritingFile of string
exception ErrorLoadingDOM
exception NoSelection
class math_view_signals :
  ([> `container | `widget] as 'b) Gtk.obj ->
  object ('a)
    inherit GContainer.container_signals
    method clicked : callback:(Gdome.element -> unit) -> GtkSignal.id
    method element_changed :
      callback:(Gdome.element option -> unit) -> GtkSignal.id
    method selection_changed :
      callback:(Gdome.element option -> unit) -> GtkSignal.id
  end
class math_view :
  (Gtk_mathview.math_view Gtk.obj as 'a)->
  object
    inherit GContainer.container
    method action_get_selected : int
    method action_set_selected : int -> unit
    method action_toggle : unit
    method connect : math_view_signals
    method export_to_postscript :
      ?width:int ->
      ?height:int ->
      ?x_margin:int ->
      ?y_margin:int ->
      ?disable_colors:bool -> filename:string -> unit -> unit
    method get_action : Gdome.element option
    method get_anti_aliasing : bool
    method get_buffer : Gdk.pixmap
    method get_element : Gdome.element option
    method get_font_manager_type : [ `font_manager_gtk | `font_manager_t1]
    method get_font_size : int
    method get_frame : GBin.frame
    method get_hadjustment : GData.adjustment
    method get_height : int
    method get_kerning : bool
    method get_log_verbosity : int
    method get_selection : Gdome.element option
    method get_top : int * int
    method get_transparency : bool
    method get_vadjustment : GData.adjustment
    method get_width : int
    method load : filename:string -> unit
    method load_tree : dom:Gdome.document -> unit
    method set_adjustments : GData.adjustment -> GData.adjustment -> unit
    method set_anti_aliasing : bool -> unit
    method set_font_manager_type :
      fm_type:[ `font_manager_gtk | `font_manager_t1] -> unit
    method set_font_size : int -> unit
    method set_kerning : bool -> unit
    method set_log_verbosity : int -> unit
    method set_selection : Gdome.element option -> unit
    method set_top : int -> int -> unit
    method set_transparency : bool -> unit
    method unload : unit
    val obj : 'a
  end
val math_view :
  ?adjustmenth:GData.adjustment ->
  ?adjustmentv:GData.adjustment ->
  ?font_size:int ->
  ?font_manager:[ `font_manager_gtk | `font_manager_t1] ->
  ?border_width:int ->
  ?width:int ->
  ?height:int ->
  ?packing:(GObj.widget -> unit) -> ?show:bool -> unit -> math_view
