/***************************************************************************
 *
 *  $Id: kzengenre.h,v 1.6 2005/06/27 16:45:53 muszilla Exp $
 *
 *  Copyright (C) 2005 by Andreas Mussgiller
 *  muszilla@users.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the
 *  Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#ifndef KZENGENRE_H
#define KZENGENRE_H

#include <qptrlist.h>
#include <qstring.h>
#include <qstringlist.h>

#include "kzenitem.h"

class QPainter;

class KZenTrack;
class KZenAlbum;
class KZenArtist;
class KZenGenreItem;

/**
@author Andreas Mussgiller
*/
class KZenGenre
{

 public:
 
  KZenGenre(const char * name);
  ~KZenGenre();

  const char *                getName() { return fName; }
  void                        setName(const char * name);

  void                        addTrack(KZenTrack *);
  void                        removeTrack(KZenTrack *);
  QPtrList<KZenTrack> *       getTrackList() { return fTracks; }

  KZenGenreItem *             getItem() { return fItem; }
  void                        setItem(KZenGenreItem * i) { fItem = i; }

  uint                        getTrackCount();
  uint                        getAlbumCount();
  uint                        getArtistCount();
  uint                        getLength();

  static QStringList &        getGenres();

 protected:

  QString                     fName;
  QPtrList<KZenTrack>        *fTracks;
  QStringList                 fAlbums;
  QStringList                 fArtists;

  static QStringList          fGenres;

  KZenGenreItem              *fItem;
};

class KZenGenreItem : public KZenItem
{
 public:

  KZenGenreItem(QListView * parent, KZenGenre * Genre);
  ~KZenGenreItem();

  KZenGenre *                 getGenre() { return fGenre; }

  void                        paintCell(QPainter*, const QColorGroup&, int, int, int);

 protected:

  KZenGenre                  *fGenre;
};

#endif
