/***************************************************************************
 *   Copyright (C) 2003 by Stephen Allewell                                *
 *   stephen@mirramar.fsnet.co.uk                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef ALPHASELECT_H
#define ALPHASELECT_H

#include <qlabel.h>
#include <qpoint.h>
#include <qrect.h>
#include <qsize.h>

/** Display a clickable preview of the import image so that an alpha color can be selected
    @author Stephen P. Allewell
  */
class AlphaSelect : public QLabel
{
  Q_OBJECT
public:
/** Constructor
    @param parent Pointer to the parent object.
  */
  AlphaSelect(QLabel* parent);
  
signals:
/** Emitted when the user clicks on a point within the preview window
  */
  void clicked(QPoint p);

protected:
/** Reimplemented from the base class.
    Called when a mouse button is pressed within the preview window
    @param e QMouseEvent describing the mouse action.
  */
  virtual void mousePressEvent(QMouseEvent* e);
/** Reimplemented from the base class.
    Called when a mouse button is released within the preview window
    @param e QMouseEvent describing the mouse action.
  */
  virtual void mouseReleaseEvent(QMouseEvent* e);

private:
};

#endif
