/***************************************************************************
 *   Copyright (C) 2003 by Stephen Allewell                                *
 *   stephen@mirramar.fsnet.co.uk                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>
#include "kxstitch.h"

static const char *description =
  I18N_NOOP("KXStitch");

static KCmdLineOptions options[] =
{
  { "+[File]", I18N_NOOP("file to open"), 0 },
  { 0, 0, 0 }
};

int main(int argc, char *argv[])
{
  KAboutData aboutData( "kxstitch", I18N_NOOP("KXStitch"),
    VERSION, description, KAboutData::License_GPL,
    "(c) 2004, Stephen Allewell", 0, 0, "stephen@mirramar.fsnet.co.uk");
  aboutData.addAuthor("Stephen Allewell",0, "stephen@mirramar.fsnet.co.uk");
  aboutData.addCredit("Pierre Brua",I18N_NOOP("Bug fixes, application icons, French translation"),"kxstitchdev@paralline.com");
  KCmdLineArgs::init( argc, argv, &aboutData );
  KCmdLineArgs::addCmdLineOptions( options );

  KXStitchApplication app;

  if (app.isRestored())
  {
    RESTORE(KXStitchApp);
  }
  else
  {
    KXStitchApp *kxstitch = new KXStitchApp();
    kxstitch->show();

    KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

    if (args->count())
    {
      kxstitch->openDocumentFile(args->arg(0));
      args->clear();
    }
  }
  return app.exec();
}
