/***************************************************************************
 *   Copyright (C) 2003 by Stephen Allewell                                *
 *   stephen@mirramar.fsnet.co.uk                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef FLOSSLISTBOXITEM_H
#define FLOSSLISTBOXITEM_H

#include <qlistbox.h>
#include "floss.h"

/** Used to add floss information to the list box allowing the user to add floss colors to the current patterns palette,
    is also used to add flosses to the calibrate dialog.
    @author Stephen P Allewell
  */
class FlossListBoxItem : public QListBoxItem
{
public:
/** Constructor
    Creates a list box item to be added to a list box
    @param listBox Pointer to the parent list box
    @param f Structure @ref FLOSSTABLEITEM defining the floss details to define this list box item
  */
  FlossListBoxItem(QListBox *listBox, Floss *f);
/** Destructor
  */
  virtual ~FlossListBoxItem();

/** Redefined virtual function
    @return The height of the list box item
    @param lb Pointer to the parent list box
  */
  virtual int height(const QListBox *lb) const;
/** Redefined virtual function
    @return The width of the list box item
    @param lb Pointer to the parent list box
  */
  virtual int width(const QListBox *lb) const;
/** Set/Clear the calibrated flag
  */
  void setCalibrated(bool);
/** Get the calibrated flag
  */
  bool isCalibrated();

  Floss *floss;

protected:
/** Redefined virtual function
    @param p Pointer to the QPainter used to draw the list box item in the form of a block of color followed by the name and description
  */
  virtual void paint(QPainter *p);

private:
  bool  m_calibrated;
};

#endif
