/***************************************************************************
                          kxmleditordoc.cpp  -  description
                             -------------------
    begin                : t ec 10 12:39:26 CEST 2001
    copyright            : (C) 2001 by The KXMLEditor Team
    email                : lvanek@eanet.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// include files for Qt
#include <qdir.h>
#include <qwidget.h>
#include <qtextcodec.h>
#include <qbuffer.h>

// include files for KDE
#include <klocale.h>
#include <kmessagebox.h>
#include <kio/job.h>
#include <kio/netaccess.h>
#include <ktar.h>

// application specific includes
#include "kxmleditordoc.h"
#include "kxmleditor.h"
#include "kxmleditorview.h"
#include "xmlstructureparser.h"
#include "xmltreeview.h"
#include "optionsdialog.h"
#include "choosestringdlg.h"

QList<KXMLEditorView> *KXMLEditorDoc::pViewList = 0L;

KXMLEditorDoc::KXMLEditorDoc(QWidget *parent, const char *name) : QObject(parent, name)
{
  if(!pViewList)
  {
    pViewList = new QList<KXMLEditorView>();
  }

  pViewList->setAutoDelete(true);
  m_bIsCompressed = false;
}

KXMLEditorDoc::~KXMLEditorDoc()
{
}

void KXMLEditorDoc::addView(KXMLEditorView *view)
{
  pViewList->append(view);
}

void KXMLEditorDoc::removeView(KXMLEditorView *view)
{
  pViewList->remove(view);
}
void KXMLEditorDoc::setURL(const KURL &url)
{
  doc_url=url;
}

const KURL& KXMLEditorDoc::URL() const
{
  return doc_url;
}

void KXMLEditorDoc::slotUpdateAllViews(KXMLEditorView *sender)
{
  KXMLEditorView *w;
  if(pViewList)
  {
    for(w=pViewList->first(); w!=0; w=pViewList->next())
    {
      if(w!=sender)
        w->repaint();
    }
  }

}

bool KXMLEditorDoc::saveModified()
{
  bool completed=true;

  if(modified)
  	{ KXMLEditorApp *win = (KXMLEditorApp *) parent();
    	int want_save = KMessageBox::warningYesNoCancel(0, // win
    																								i18n("The current file has been modified.\n""Do you want to save it?"),
    																								i18n("Warning"));
    	switch(want_save)
    		{ case KMessageBox::Yes:
    							if(doc_url.fileName() == i18n("Untitled"))
           					{ win->slotFileSaveAs();
           					}
           				else
           					{ saveDocument(URL());
       	   					}

       	   				deleteContents();
           				completed=true;
           				break;

      		case KMessageBox::No:
           				modified = false;
           				deleteContents();
           				completed=true;
           				break;	

      		case KMessageBox::Cancel:
           				completed=false;
           				break;

      		default:
           				completed=false;
           				break;
    		}
  	}

  return completed;
}

void KXMLEditorDoc::closeDocument()
{
  deleteContents();
}

bool KXMLEditorDoc::newDocument()
{
  modified=false;
  doc_url.setFileName(i18n("Untitled"));
  deleteContents();

  return true;
}

bool KXMLEditorDoc::openDocument(const KURL& url,
																 const QString &strCompressedTarEntryName,
																 const char * /*szFormat*/ /*=0*/)
{
  if(url.path().isEmpty())
		return true;

	// delete old XML tree
	deleteContents();

	// get view
	KXMLEditorView *pView = pViewList->first();
		
	// download XML file	
  QString tmpfile;
  KIO::NetAccess::download(url, tmpfile);

  // obtain file extension -----------------------------------------
	QString strExtension;
	
	QString strFileName = url.fileName();
	int iPos = strFileName.findRev('.');
	
	if(iPos > 0)
		{ strExtension = strFileName.mid(iPos + 1);
		}

	// if file is compressed, decompres it to another temporary file -
	if(OptionsDialog::getListOfTarGzExtensions().contains(strExtension))
		{ KTarGz	tarGzFile(tmpfile);
			QFile fileTemporary("temporary.tmp");
			
			tarGzFile.open(IO_ReadOnly);
			fileTemporary.open(IO_WriteOnly);
			
			const KTarDirectory *root = tarGzFile.directory();
  		if(!root)
    		return false;
    		
    	if(strCompressedTarEntryName.length() == 0)	
    		{ ChooseStringDlg dlgChooseString(pView, 0, i18n("Choose file"), i18n("File:"));
    		  dlgChooseString.m_pComboBox->insertItem("maindoc.xml");
    			dlgChooseString.m_pComboBox->insertItem("documentinfo.xml");
    			if(dlgChooseString.exec() != ChooseStringDlg::Accepted)
						{ return false;
						}
					m_strCompressedTarEntryName = dlgChooseString.m_strChoosedText;
				}
			 else
			 	{ m_strCompressedTarEntryName = strCompressedTarEntryName;
			 	}
  		
			const KTarEntry *entry = root->entry(m_strCompressedTarEntryName);
			 	
			if(entry && entry->isFile())
  			{ const KTarFile *pTarFile = static_cast <const KTarFile *> (entry);

    			QBuffer buffer(pTarFile->data());
    			buffer.open(IO_ReadOnly);
    			
    			fileTemporary.writeBlock(buffer.buffer(), buffer.size());
    			
  			}
  		else
  			m_strCompressedTarEntryName.truncate(0);
			
			tarGzFile.close();
			tmpfile = fileTemporary.name();
			fileTemporary.close();
			
			m_bIsCompressed = true;
		}
	else
		m_bIsCompressed = false;

	// open and parse XML file ----------------------------------------
	QFile file(tmpfile);

	if(OptionsDialog::getXmlParser() == OptionsDialog::parserSAX2)
		openSAX2(file);
	else
		openDOM(file);
		
	//-----------------------------------------------------------------

  KIO::NetAccess::removeTempFile(tmpfile);

  modified = false;
  setURL(url);
  return true;
}

/** Open XML file using SAX2 parser */
bool KXMLEditorDoc::openSAX2(QFile &file)
{
	// get view
	KXMLEditorView *pView = pViewList->first();
	
	QXmlSimpleReader xmlReader;
	XmlStructureParser handlerSAX2(pView->getElementsTreeView(), this);
	
	xmlReader.setContentHandler(&handlerSAX2);
	xmlReader.setLexicalHandler(&handlerSAX2);
	xmlReader.setErrorHandler(&handlerSAX2);
	
	xmlReader.setFeature( "http://xml.org/sax/features/namespaces", TRUE );
  xmlReader.setFeature( "http://xml.org/sax/features/namespace-prefixes", TRUE );

  if(xmlReader.parse(QXmlInputSource(file)) == false)
		{ KMessageBox::error(0,
												 i18n("%1 in line %2, column %3").arg(handlerSAX2.GetErrorMsg()).arg(handlerSAX2.GetLineNumber()).arg(handlerSAX2.GetColumnNumber()),
												 i18n("Parsing error !"));
		  return false;
		}
		
	return true;
}

/** Open XML file using DOM parser */
bool KXMLEditorDoc::openDOM(QFile &file)
{
	QDomDocument doc("mydocument");
	
	if(!file.open(IO_ReadOnly))
      return false;

  if(!doc.setContent(&file))
  	{ file.close();
      return false;
    }

  file.close();

  // get view
	KXMLEditorView *pView = pViewList->first();

	// add XML document to tree view
	addDomNodeToTree(pView, doc, 0, 0);
  	
	return true;
}

/** Parse string using DOM parser */
bool KXMLEditorDoc::parseDOM(const QString &strXml, XmlElement* pXmlElementParent)
{
	QDomDocument doc("mydocument");
	
	if(!doc.setContent(strXml))
  	{ return false;
    }

  // get view
	KXMLEditorView *pView = pViewList->first();

	// add XML document to tree view
	addDomNodeToTree(pView, doc, pXmlElementParent, 0);
  	
	return true;
}
/** Add DOM node to tree view */
XmlTreeItem *KXMLEditorDoc::addDomNodeToTree(KXMLEditorView *pView,
																						 QDomNode &nodeParent,
																						 XmlElement* pXmlElementParent,
																						 unsigned int iLevel)
{
				
	
	XmlTreeItem *pXmlTreeItem = 0;
	XmlTreeItem *pLastChild = 0;
	
	// traverse childs and add it to tree view
	QDomNode node = nodeParent.firstChild();
  while(!node.isNull())
  	{ switch(node.nodeType())
  			{ case QDomNode::ElementNode:
  														{ QDomElement element = node.toElement();
      													if(!element.isNull())
      														{ // create new element
																		XmlElement* pXmlElement;
	
																		if(pXmlElementParent)
																			pXmlElement = new XmlElement(pXmlElementParent, element.tagName(), "" /*namespaceURI*/);
																		else			
																			pXmlElement = new XmlElement(pView->getElementsTreeView(), element.tagName(), "" /*namespaceURI*/);
	
																		pXmlTreeItem = pXmlElement;
																			
																		// expand node, if necessary
																		if(iLevel < OptionsDialog::getTreeViewExpandToLevel())
																			pXmlElement->setOpen(true);
			
																		// traverse list of attributes
																		QDomNamedNodeMap nodeMap = element.attributes();
																		unsigned int iLength = nodeMap.length();
	
																		for(unsigned int i = 0; i < iLength; i++)
																			{ QDomNode node = nodeMap.item(i);
		  																	QDomAttr attribute = node.toAttr();
		
		  																	if(!attribute.isNull())
		  																		{ pXmlElement->appendAttribute(new XmlAttribute(attribute.name(), attribute.value()));
		  																		}
																			}

																		// update column with attributes list
  																	pXmlElement->updateStringAttrList();
  														
  																	// RECURSE, RECURSE, RECURSE ...
  																	addDomNodeToTree(pView, element, pXmlElement, iLevel + 1);
      														}
      												}
      													break;
      		
   				case QDomNode::ProcessingInstructionNode:
   														{ QDomProcessingInstruction procInstruction = node.toProcessingInstruction();
   														  if(!procInstruction.isNull())
      														{ if(pXmlElementParent)
      																pXmlTreeItem = new XmlProcessingInstruction(pXmlElementParent, procInstruction.target(), procInstruction.data());
      														  else
      																pXmlTreeItem = new XmlProcessingInstruction(pView->getElementsTreeView(), procInstruction.target(), procInstruction.data());
      														}
   														}											
      													break;
      													
      		case QDomNode::TextNode:
   														{ QDomText text = node.toText();
   															if(!text.isNull())
      														{ ASSERT(pXmlElementParent);
      															pXmlTreeItem = new XmlContentsItem(pXmlElementParent, text.data(), XmlTreeItem::itemText);
   																}
   														}											
      													break;
      													
      		case QDomNode::CharacterDataNode:
   														{ QDomCharacterData character = node.toCharacterData();
   															if(!character.isNull())
      														{ ASSERT(pXmlElementParent);
      															pXmlTreeItem = new XmlContentsItem(pXmlElementParent, character.data(), XmlTreeItem::itemText);
   																}
   														}											
      													break;
      													
      		case QDomNode::CDATASectionNode:
   														{ QDomCDATASection cdata = node.toCDATASection();
   															if(!cdata.isNull())
      														{ ASSERT(pXmlElementParent);
      															pXmlTreeItem = new XmlContentsItem(pXmlElementParent, cdata.data(), XmlTreeItem::itemCDATA);
   																}
   														}											
      													break;
      													
      	  case QDomNode::CommentNode:
   														{ QDomComment comment = node.toComment();
   															if(!comment.isNull())
      														{ if(pXmlElementParent)
      																pXmlTreeItem = new XmlContentsItem(pXmlElementParent, comment.data(), XmlTreeItem::itemComment);
      														  else
      														  	pXmlTreeItem = new XmlContentsItem(pView->getElementsTreeView(), comment.data(), XmlTreeItem::itemComment);
   																}
   														}											
      													break;								
      													
   			}
   			
   		// sort properly new item after last child
   		if(pXmlTreeItem)
   			{ if(!pLastChild)
   					pLastChild = pXmlTreeItem;
   			  else
   			    { pXmlTreeItem->moveItem(pLastChild);
   						pLastChild = pXmlTreeItem;
   			    }
   			}
   		
   		// get next child
      node = node.nextSibling();
  	}
  return pXmlTreeItem;
}


bool KXMLEditorDoc::saveDocument(const KURL& url, const char */*szFormat*/ /*=0*/)
{
  if(url.path().isEmpty())
		return true;
	
	// get view
	KXMLEditorView *pView = pViewList->first();
	
	// save XML processing instructions
	QString strXML;
	
	// save XML tree to string
	XmlTreeItem* pXmlTreeItem = static_cast <XmlTreeItem *> (pView->getElementsTreeView()->firstChild());
	while(pXmlTreeItem)
  		{ pXmlTreeItem->save(strXML, 0);
  			
  			pXmlTreeItem = static_cast <XmlTreeItem *> (pXmlTreeItem->nextSibling());
  		}
		
	// save string to file
	QTextCodec *pTextCodec;
	if(m_strEncoding.length() > 0)
		pTextCodec = QTextCodec::codecForName(m_strEncoding);
	else
	 	pTextCodec = QTextCodec::codecForName("ISO-8859-1");
	 	
	if(pTextCodec == 0)
		{ if(KMessageBox::questionYesNo(0, i18n("Codec for encoding %1 bot found ! Continue saving ?").arg(m_strEncoding)) != KMessageBox::Yes)
					return false;
		}
	    				
	QCString strDecoded;
	if(pTextCodec)
		{ strDecoded = pTextCodec->fromUnicode(strXML);
		}
				
	if(!m_bIsCompressed)
	  	{ QFile file(url.path());
				if(file.open(IO_WriteOnly) == true)
					{ file.writeBlock(strDecoded, strDecoded.length());
	  				file.flush();
	  				file.close();
	  			}
	  		else
					{ KMessageBox::error(0,
												 i18n("Can't create file %1").arg(url.path()),
												 i18n("Write error !"));
					}
	  	}
	else
	  	{ KTarGz	tarGzFile(url.path());
	  		if(tarGzFile.open(IO_WriteOnly))
	  			{ tarGzFile.writeFile(m_strCompressedTarEntryName, "user", "group", strDecoded.length(), strDecoded);
	  				tarGzFile.close();
		  		}
		  	else
					{ KMessageBox::error(0,
												 i18n("Can't create archive %1").arg(url.path()),
												 i18n("Write error !"));
					}
			}
	
  modified=false;
  return true;
}

void KXMLEditorDoc::deleteContents()
{
  // get view
	KXMLEditorView *pView = pViewList->first();
	
	// clear view, delete XML tree in memory
	if(pView)
		pView->clearView();
}

