#ifndef KWLANMAINWIN_H
#define KWLANMAINWIN_H
/** KWlan
 *
 *  This File is part of KWlan, a network Manager for KDE.
 *  KWlan is distributed under LGPL license.
 *
 *	@author Thomas Michel <tom.michel@arcor.de>
 */

#include "kwlan.h"
#include "configuration.h"
#include "wpa_ctrl.h"
#include "kwlantraywin.h"
#include "wpamsg.h"
#include <kapplication.h>
#include <qstringlist.h>
#include <qsocketnotifier.h>
#include <qptrlist.h>

class KScanDlg;
class KEventHistoryDlg;
class KUserDataRequestDlg;
class KTempFile;
class KWlanInterface;
class Configuration;
class KDialup;
class KProcess;
class KWlanMainTrayWin;

class KWlanMainWin : public Kwlan
{
    Q_OBJECT

    public:
        KWlanMainWin(QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
        ~KWlanMainWin();
        /*$PUBLIC_FUNCTIONS$*/
        QStringList getInterfaces()
        {
            return m_interfaces;
        }
    
        void checkInterfacesIfconfig();
        void checkInterfacesSysClass();
    public slots:
        /*$PUBLIC_SLOTS$*/
        virtual void          fileSettings();
        virtual void          profileActivate();
        virtual void          cbInterfaceChanged(const QString&);
        virtual void          scan();
        virtual void          profileDelete();
        virtual void          profileModify();
        virtual void          profileNew();
        virtual void          dialupNew();
        virtual void          dialupDelete();
        virtual void          dialupModify();
        virtual void          dialupDisconnect();
        virtual void          dialupConnect();
        virtual int           init();
        virtual void          helpAbout();
        virtual void          fileExit();
        void updateDialupNetworks();
        void slotInterfaceGone(KWlanInterface *interface);
        void close();
        void ifconfigProcessStdout( KProcess* process, char* buffer, int buflen );
        void ifconfigProcessExited( KProcess* process );
        void slotCheckInterfaces();
        void slotChangeInterface(QString iface);

    
        
    protected:
        /*$PROTECTED_FUNCTIONS$*/
    
    protected slots:
        /*$PROTECTED_SLOTS$*/
        
    private:
    
        bool getRootPassword();
        QStringList m_wlanInterfaces;
        QSocketNotifier *m_messageNotifier;
        Configuration *m_configuration;
        QString m_confFile;
        QStringList m_interfaces;
        QPtrList<KWlanInterface> m_interfaceList;
        QString m_ifconfigStdout;
        KWlanMainTrayWin *m_tray;
        QTimer *m_timer;
        KProcess *m_ifconfigProcess;
        QString m_ifconfigPath;
        bool m_useIfconfig;
};

#endif

























