

#include "kwlanmainwin.h"
#include "wlanlib.h"
#include "kprofileconfigdlg.h"
#include "kstartsupplicantdlg.h"
#include "wpa_ctrl.h"
#include "keventhistorydlg.h"
#include "kscandlg.h"
#include "kuserdatarequestdlg.h"
#include "kwlansettingsdlg.h"
#include "kwlansuprocess.h"
#include "kwlaninterface.h"
#include "dialup.h"
#include "kdialup.h"
#include "kdialupconfigdlg.h"
#include "kwlanmaintraywin.h"
#include "configuration.h"
#include "kwlanmainsettingsdlg.h"
#include "globals.h"

#include <iostream>
#include <kstdaction.h>
#include <kaction.h>
#include <qlistbox.h>
#include <qlineedit.h>
#include <qcombobox.h>
#include <qapplication.h>
#include <qtimer.h>
#include <qlabel.h>
#include <qaction.h>
#include <unistd.h>
#include <dirent.h>
#include <klocale.h>
#include <qstringlist.h>
#include <qfile.h>
#include <qfileinfo.h>
#include <kaboutapplication.h>
#include <qcstring.h>
#include <kpassdlg.h>
#include <kmessagebox.h>
#include <ktempfile.h>
#include <kstandarddirs.h>
#include <kpassdlg.h>
#include <kdebug.h>
#include <qcheckbox.h>
#include <qspinbox.h>
#include <qpushbutton.h>
#include <kprocess.h>
#include <qdir.h>


KWlanMainWin::KWlanMainWin(QWidget* parent, const char* name, WFlags fl)
    : Kwlan(parent,name,fl)
{
    m_ifconfigProcess=0L;
    m_ifconfigPath = getPath("ifconfig");
    if (m_ifconfigPath.isEmpty())
    {
        KMessageBox::error(this, i18n("Could not find ifconfig. Without it KWlan won't detect any interface."));
    }
    QDir dir("/sys/class/net");
    if (dir.exists()) {
        m_useIfconfig = FALSE;
    } else {
        m_useIfconfig = TRUE;
    }
}

int KWlanMainWin::init() 
{
    
    if (!mainConfiguration().readStartMinimized())
        show();
    // now update Dialup Networks
    updateDialupNetworks();
    m_tray = new KWlanMainTrayWin( this, "KWlan" );
    m_tray->show();
    connect( m_tray, SIGNAL( quitSelected() ), this, SLOT( fileExit() ) );
    connect(m_tray, SIGNAL (aboutSelected() ),this, SLOT(helpAbout()));
    slotCheckInterfaces();
    m_timer = new QTimer(this);
    if (m_timer){
        connect (m_timer, SIGNAL(timeout()),SLOT(slotCheckInterfaces()));
        m_timer->start(5000,FALSE);
    }

    return 0;
}

KWlanMainWin::~KWlanMainWin()
{
    if (m_timer)
        delete m_timer;
    //m_configuration->writeSettings();
}


void KWlanMainWin::checkInterfacesIfconfig()
{
    if (m_ifconfigProcess || m_ifconfigPath.isEmpty()) return;
    m_ifconfigStdout=QString::null;
    m_ifconfigProcess = new KProcess();
    m_ifconfigProcess->setEnvironment( "LANG", "C" );
    m_ifconfigProcess->setEnvironment( "LC_ALL", "C" );
    *m_ifconfigProcess << m_ifconfigPath << "-a";
    connect( m_ifconfigProcess,  SIGNAL( receivedStdout( KProcess*, char*, int ) ),
             this, SLOT( ifconfigProcessStdout( KProcess*, char*, int ) ) );
    connect( m_ifconfigProcess,  SIGNAL( processExited( KProcess* ) ),
             this, SLOT( ifconfigProcessExited( KProcess* ) ) );

    if ( !m_ifconfigProcess->start( KProcess::NotifyOnExit, KProcess::Stdout ) )
    {
        delete m_ifconfigProcess;
        m_ifconfigProcess = 0L;
    }
}

void KWlanMainWin::checkInterfacesSysClass()
{
    QDir dir("/sys/class/net");
    QStringList list = dir.entryList(QDir::Dirs);
    list.pop_front(); // removes "." and ".." entries
    list.pop_front();
    for ( QStringList::iterator it = list.begin(); it != list.end(); ++it )
    {
        QString iface = (*it);
        QString typeFile = QString("/sys/class/net/");
        typeFile += iface;
        typeFile += QString("/type");
        // check if interface type is ethernet
        FILE* fp = fopen((typeFile).latin1(), "r");
        long retval = 0;
        if (fp)
        {
            fscanf(fp, "%lu", &retval);
            fclose(fp);
        }

        if (retval==1)
        {
            if (debugOutput) kdDebug() << "Checking interface "<<iface << endl;
            bool found = FALSE;
            KWlanInterface *it;
            for (it = m_interfaceList.first(); it ;it = m_interfaceList.next())
            {
                if (it->getInterfaceName()==iface) found = TRUE;
            }
            if (!found)
            {
                KWlanInterface *widget = new KWlanInterface();
                widget->init(iface );
                connect (widget, SIGNAL(interfaceGone(KWlanInterface*)), this, SLOT(slotInterfaceGone(KWlanInterface*)));
                
                KWlanTrayWin *trayWin = new KWlanTrayWin(this,"KWlan");
                trayWin->setInterface(widget);
                trayWin->setInterfaceName(iface);
                connect(trayWin, SIGNAL( quitSelected() ), this, SLOT( fileExit() ) );
                connect(trayWin, SIGNAL (aboutSelected()),this,SLOT(helpAbout()));
                connect (m_tray, SIGNAL(sigMonitorInterface(QString, bool)), trayWin, SLOT(slotShowTrayWin(QString,bool)));
                connect (trayWin, SIGNAL (sigTrayWinClicked(QString)), this, SLOT(slotChangeInterface( QString)));
                if (mainConfiguration().readMonitorInterface(iface)) trayWin->show();
                
                m_interfaces.append(iface);
                m_interfaceList.append(widget);
                cbInterface->insertItem(iface);
                cbInterface->setCurrentText(iface);
                if (debugOutput) kdDebug() << "Added interface " << iface << endl;
            }
        }
    }

}

void KWlanMainWin::slotCheckInterfaces()
{
    if (m_useIfconfig) checkInterfacesIfconfig();
    else checkInterfacesSysClass();
}

/*$SPECIALIZATION$*/
void KWlanMainWin::fileSettings()
{
    KWlanMainSettingsDlg *settings = new KWlanMainSettingsDlg();
    if (!settings) return;
    settings->show();
    settings->exec();
}

void KWlanMainWin::profileActivate()
{
    QString iface = cbInterface->currentText();
    KWlanInterface *it;
    for (it = m_interfaceList.first();it; it=m_interfaceList.next())
    {
        if (it->getInterfaceName()== iface)
        {
            it->profileActivate( lbProfiles->currentText());
        }
    }

}

void KWlanMainWin::cbInterfaceChanged(const QString& iface)
{
    if (debugOutput) kdDebug() << "Selected interface has changed to "<<iface << endl;
    KWlanInterface *it;
    for (it = m_interfaceList.first();it; it=m_interfaceList.next())
    {
        if (it->getInterfaceName()== iface)
        {
            QStringList profiles = it->listProfiles();
            lbProfiles->clear();
            lbProfiles->insertStringList(profiles);
        }
    }
}

void KWlanMainWin::scan()
{
    QString iface = cbInterface->currentText();
    KWlanInterface *it;
    for (it = m_interfaceList.first();it; it=m_interfaceList.next())
    {
        if (it->getInterfaceName()== iface)
        {
            it->slotScan();
        }
    }
}

void KWlanMainWin::profileDelete()
{
    QListBoxItem *selected = lbProfiles->selectedItem();
    // check if a profile is selected
    if (selected)
    {
        int answer = KMessageBox::warningYesNo(this,i18n("Do you really want to delete this profile?"));
        if (answer==KMessageBox::Yes){
            QString iface = cbInterface->currentText();
            KWlanInterface *it;
            for (it = m_interfaceList.first();it; it=m_interfaceList.next())
            {
                if (it->getInterfaceName()== iface)
                {
                    it->slotDeleteProfile( lbProfiles->currentText());
                    lbProfiles->clear();
                    lbProfiles->insertStringList(it->listProfiles());
                }
            }
        }
    }
}

void KWlanMainWin::profileModify()
{
    QString iface = cbInterface->currentText();
    QListBoxItem *selected = lbProfiles->selectedItem();
    // check if a profile is selected
    if (selected)
    {
        KWlanInterface *it;
        for (it = m_interfaceList.first();it; it=m_interfaceList.next())
        {
            if (it->getInterfaceName()== iface)
            {
                it->slotEditProfile( lbProfiles->currentText());
            }
        }

    }
}

void KWlanMainWin::profileNew()
{
        // Open Config Dialog
    QString iface = cbInterface->currentText();
    KWlanInterface *it;
    for (it = m_interfaceList.first();it; it=m_interfaceList.next())
    {
        if (it->getInterfaceName()== iface)
        {
            KProfileConfigDlg *profileDlg = new KProfileConfigDlg();
            if (!profileDlg) return;
            profileDlg->setInterface( it);
            profileDlg->newNetwork();
            profileDlg->show();
            profileDlg->exec();
            cbInterfaceChanged(iface);
            return;
        }
    }
}

void KWlanMainWin::dialupNew()
{
    KDialupConfigDlg *conf = new KDialupConfigDlg();
    connect (conf, SIGNAL(dialupNetworksUpdated()),this, SLOT(updateDialupNetworks()));
    conf->show();
}

void KWlanMainWin::dialupDelete()
{
    QListBoxItem *selected = lbDialup->selectedItem();
    // check if a profile is selected
    if (!selected) {
        KMessageBox::sorry(this,i18n("No network selected!"));
        return;
    }
    int answer = KMessageBox::warningYesNo(this,i18n("Do you really want to delete this profile?"));
    if (answer==KMessageBox::Yes){
        QString filename = QString(PPP_PEERS) + QString("/") + lbDialup->currentText();
        KWlanSuProcess *proc = new KWlanSuProcess();
        *proc << "rm" << filename;
        proc->setDescription( i18n("delete dialup network"));
        updateDialupNetworks();
        proc->start();
    }
}

void KWlanMainWin::dialupModify()
{
    // get network
    QListBoxItem *selected = lbDialup->selectedItem();
    // check if a profile is selected
    if (!selected) {
        KMessageBox::sorry(this,i18n("No network selected!"));
        return;
    }
    
    QString sel(lbDialup->currentText());
    KDialupConfigDlg *conf = new KDialupConfigDlg();
    connect (conf, SIGNAL(dialupNetworksUpdated()),this, SLOT(updateDialupNetworks()));
    if (conf->init(sel))
        conf->show();
        else delete conf;
}

void KWlanMainWin::dialupDisconnect()
{
    // get network
    QListBoxItem *selected = lbDialup->selectedItem();
    // check if a profile is selected
    if (!selected) {
        KMessageBox::sorry(this,i18n("No network selected!"));
        return;
    }
    
    QString sel(lbDialup->currentText());
    KDialup *tmpDial = new KDialup;
    tmpDial->disconnectNetwork(sel);
    delete tmpDial;
    

}

void KWlanMainWin::dialupConnect()
{
    // get network
    QListBoxItem *selected = lbDialup->selectedItem();
    // check if a profile is selected
    if (!selected) {
        KMessageBox::sorry(this,i18n("No network selected!"));
        return;
    }
    KDialup *dialup = new KDialup();
    QString sel(lbDialup->currentText());
    dialup->connectNetwork(sel);

}


void KWlanMainWin::helpAbout()
{
    KAboutApplication about(this);
    about.exec();
}


void KWlanMainWin::fileExit()
{
    //m_configuration->writeSettings();
    kdDebug() << "Exiting..." << endl;
    kapp->quit();
}



void KWlanMainWin::updateDialupNetworks()
{
    kdDebug() << "Updating dialup networks" << endl;
    QStringList networks = listDialupNetworks();
    lbDialup->clear();
    for (QStringList::iterator it = networks.begin();it != networks.end();it++)
    {
        lbDialup->insertItem(*it);
    }
}


void KWlanMainWin::close()
{
    Kwlan::close();
}


void KWlanMainWin::ifconfigProcessExited( KProcess* process )
{
    //QMap<QString, QString> configs;
    if (process != m_ifconfigProcess) return;
    delete m_ifconfigProcess;
    m_ifconfigProcess=0L;
    QStringList ifList = QStringList::split( "\n\n", m_ifconfigStdout );
    QStringList::Iterator it;
    for ( it = ifList.begin(); it != ifList.end(); ++it )
    {
        int index = ( *it ).find( ' ' );
        if ( index == -1 )
            continue;
       // QString key = ( *it ).left( index );
        //configs[key] = ( *it ).mid( index );
        
        if ( (*it).mid(index).contains( "Ethernet" ))// || (*it).mid(index).contains( "Point-to-Point" ))
        {
            QString iface = (*it).left(index);
            if (debugOutput) kdDebug() << "Checking interface "<<iface << endl;
            bool found = FALSE;
            KWlanInterface *it;
            for (it = m_interfaceList.first(); it ;it = m_interfaceList.next())
            {
                if (it->getInterfaceName()==iface) found = TRUE;
            }
            //if ( m_interfaces.findIndex(iface) == -1)
            if (!found)
            {
                KWlanInterface *widget = new KWlanInterface();
                widget->init(iface );
                connect (widget, SIGNAL(interfaceGone(KWlanInterface*)), this, SLOT(slotInterfaceGone(KWlanInterface*)));
                
                KWlanTrayWin *trayWin = new KWlanTrayWin(this,"KWlan");
                trayWin->setInterface(widget);
                trayWin->setInterfaceName(iface);
    //m_traywin->setProfile(m_network);
                connect(trayWin, SIGNAL( quitSelected() ), this, SLOT( fileExit() ) );
                connect(trayWin, SIGNAL (aboutSelected()),this,SLOT(helpAbout()));
                connect (m_tray, SIGNAL(sigMonitorInterface(QString, bool)), trayWin, SLOT(slotShowTrayWin(QString,bool)));
                connect (trayWin, SIGNAL (sigTrayWinClicked(QString)), this, SLOT(slotChangeInterface( QString)));
                if (mainConfiguration().readMonitorInterface(iface)) trayWin->show();
                
                m_interfaces.append(iface);
                m_interfaceList.append(widget);
                cbInterface->insertItem(iface);
                cbInterface->setCurrentText(iface);
                if (debugOutput) kdDebug() << "Added interface " << iface << endl;
            }
        }
    }
}

void KWlanMainWin::ifconfigProcessStdout( KProcess* process, char* buffer, int buflen )
{
    if (debugOutput) kdDebug() << QString::fromLatin1( buffer, buflen ) << endl;
    m_ifconfigStdout += QString::fromLatin1( buffer, buflen );
}

void KWlanMainWin::slotInterfaceGone(KWlanInterface *iface)
{
    if (debugOutput) kdDebug() << "Lost interface " << iface->getInterfaceName() << endl;
    int id = m_interfaceList.find(iface);
    if (id!=-1)
        m_interfaceList.remove(id);
}

void KWlanMainWin::slotChangeInterface( QString iface)
{
    cbInterface->setCurrentText(iface);
}
#include "kwlanmainwin.moc"




















