/***************************************************************************
                          kweather.h  -  description
                             -------------------
    begin                : Wed Jul  5 23:09:02 CDT 2000
    copyright            : (C) 2000 by Ian Reinhart Geiser
    email                : geiseri@msoe.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KWEATHER_H
#define KWEATHER_H
#define dcop_iface

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapp.h>

#include <kconfig.h>
#include <qwidget.h>
#include <kpanelapplet.h>
#include <qtimer.h>
#include <kprocess.h>
#include "weatherlib.h"
#include "prefsDialog.h"
#include "reportview.h"
#include <dockwidget.h>
#include "weatherIface.h"
#include <kio/job.h>
#include <klocale.h>
#include <qpixmap.h>
#include <kstddirs.h>
#include <dcopclient.h>
#include <qfont.h>

class kweather : public KPanelApplet
#ifdef dcop_iface
					,  virtual public weatherIface
#endif
{
  Q_OBJECT
  public:
    /** construtor */
    kweather(const QString& configFile, Type t = Normal, int actions = 0, QWidget *parent = 0, const char *name = 0);
    /** destructor */
    ~kweather();
  /** about box */
  void about();
  /** prefs */
  void preferences();
  /** The help handler */
  void help();
  /**  */
  int heightForWidth(int i) const;
  /**  */
  int widthForHeight(int i) const;
  /** This will return the current temperature.  This is only ment to be used through the DCOP interface. */
  QString get_temperature();
  /** This will return the current pressure. This is only ment for the DCOP interface */
  QString get_pressure();
  /** return current weather */
  QString get_weather();
  /** return wind info */
  QString get_wind();
  /** derived paint event */
  //void paintEvent( QPaintEvent* );
  void refresh();

public slots: // Public slots
  /** Get the button event from the child widget */
  void getButtonEvent();
  /** Display the current weather report. */
  void doReport();
  /** Get data from the download job **/
  void downloadData( KIO::Job *, const QByteArray &data);
  /** Load the data into the current memory */
  void loadFile( KIO::Job *aJob);
  /** get new data */
  void timeout();
private: // Private methods
  /** load the application prefs */
  void loadPrefs();
  /** Save the application prefs. */
  void savePrefs();
  /** The METAR code for the current report location */
  QString reportLocation;
  /** The config variable */
  KConfig *kcConfig;
  /** The number of hours from the GMT */
  int GMT_Offset;
	int LCD_Value;
	QString FileName;
	bool firstrun;
	bool MetricMode;
	bool OffLineMode;
	bool smallviewMode;
	QTimer *timeOut;
	QFont theFont;
//  dataProvider dataProv;
  KProcess *ftpProc;
	int status;
	weatherlib *weather;
	dockwidget *p;
	reportView *theView;
  /** The ioslave that will handle the ftp connection. */
  KIO::TransferJob *theJob;
  QString metarData;
  QString curTemp;
	DCOPClient *theClient;

};

#endif
