/***************************************************************************
*   Copyright (C) 2004 by Christoph Thielecke                             *
*   crissi99@gmx.de                                                       *
*   contains some code from openvpn-kde-dialogs.pl which is     *
*   written by  Alon Bar-Lev <alon.barlev@gmail.com>                *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#include "openvpnmanagementhandler.h"
#include <qregexp.h>
#include <qtextstream.h>
#include <kpassdlg.h>
#include <klocale.h>
#include <qlabel.h>
#include <qcheckbox.h>
#include <kmessagebox.h>
#include <kinputdialog.h>
#include "kvpncconfig.h"
#include "enterxauthinteractivepasscodedialog.h"

OpenvpnManagementHandler::OpenvpnManagementHandler( QObject *, KVpncConfig *GlobalConfig ) {
	this->GlobalConfig = GlobalConfig;
	fInHold = false;
	socket = new QSocket( this );
	connect( socket, SIGNAL( connected() ), SLOT( socketConnected() ) );
	connect( socket, SIGNAL( connectionClosed() ), SLOT( socketConnectionClosed() ) );
	connect( socket, SIGNAL( readyRead() ), SLOT( socketReadyRead() ) );
	connect( socket, SIGNAL( error( int ) ), SLOT( socketError( int ) ) );

	if ( GlobalConfig->KvpncDebugLevel > 2 )
		GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: start", GlobalConfig->debug );

	socket->connectToHost( "127.0.0.1", GlobalConfig->OpenvpnManagementPort );
}

OpenvpnManagementHandler::~OpenvpnManagementHandler() {}

void OpenvpnManagementHandler::closeConnection() {
	socket->close();
	if ( socket->state() == QSocket::Closing ) {
		// We have a delayed close.
		connect( socket, SIGNAL( delayedCloseFinished() ),
		         SLOT( socketClosed() ) );
	} else {
		// The socket is closed.
		socketClosed();
	}
}

void OpenvpnManagementHandler::socketConnectionClosed() {
	if ( GlobalConfig->KvpncDebugLevel > 2 )
		GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: " + i18n( "Disconnected to the OpenVPN manage port (%1)." ).arg( QString().setNum( GlobalConfig->OpenvpnManagementPort ) ), GlobalConfig->debug );

}

void OpenvpnManagementHandler::socketClosed() {}

void OpenvpnManagementHandler::socketConnected() {

	if ( GlobalConfig->KvpncDebugLevel > 2 )
		GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: " + i18n( "Connected to the OpenVPN manage port (%1)." ).arg( QString().setNum( GlobalConfig->OpenvpnManagementPort ) ), GlobalConfig->debug );

}

void OpenvpnManagementHandler::socketError( int e ) {
	//         infoText->append( tr("Error number %1 occurred\n").arg(e) );
	GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: " + QString().setNum( e ) , GlobalConfig->error );
}

void OpenvpnManagementHandler::sendToServer( QString cmd ) {
	// write to the server
	QTextStream os( socket );
	os << cmd << "\n";
}

void OpenvpnManagementHandler::socketReadyRead() {
	// 	if ( socket->canReadLine() )
	// {
	// 		QString line = socket->readLine();

	QCString s;
	s.resize( socket->bytesAvailable() + 1 );
	socket->readBlock( s.data(), socket->bytesAvailable() );
	QString line( s );
	{

		if ( GlobalConfig->KvpncDebugLevel > 2 )
			GlobalConfig->appendLogEntry( "OpenvpnManagementHandler raw: " + line, GlobalConfig->debug );


		// 		if ( line.find( ">HOLD:", 0, FALSE ) > -1 ) {
		//
		// 			if ( GlobalConfig->KvpncDebugLevel > 2 )
		// 				GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: " + i18n( "got 'hold' message." ), GlobalConfig->debug );
		//
		// 			fInHold = true;
		// 			int ret = 0;
		// 			do {
		// 				ret = KMessageBox::questionYesNo ( 0, i18n( "Release hold?" ), i18n( "OpenVPN" ) );
		// 			} while ( ret != 0 );
		//
		// 			sendToServer( "hold release\n" );
		//
		// 			if ( GlobalConfig->KvpncDebugLevel > 2 )
		// 				GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: " + i18n( "hold release sent." ), GlobalConfig->debug );
		//
		// 			socket->close();
		// 			fInHold = false;
		// 		}
		if ( line.find( "> NEED - OK:", 0, FALSE ) > -1 ) {

			if ( GlobalConfig->KvpncDebugLevel > 2 )
				GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: " + i18n( "got 'need ok' message" ), GlobalConfig->debug );

			QString req = line.section( QRegExp( ".*'(.*)'. * MSG:( .* )" ), 0, 0 ); // $1;
			QString msg = line.section( QRegExp( ".*'(.*)'. * MSG:( .* )" ), 1, 1 ); // $2;

			if ( GlobalConfig->KvpncDebugLevel > 2 )
				GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: " + i18n( "req: %1, msg: %2" ).arg( req ).arg( msg ), GlobalConfig->debug );

			//TODO: look for possible messages, msg2 is the translatable msg
			QString msg2 = msg;

			int ret = KMessageBox::questionYesNo ( 0, msg2, i18n( "OpenVPN" ) );


			if ( ret == 0 ) {

				if ( GlobalConfig->KvpncDebugLevel > 2 )
					GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: " + i18n( "'needok': %1" ).arg( i18n( "ok" ) ), GlobalConfig->debug );

				sendToServer( "needok \"" + req + "\" ok\n" );
			} else {

				if ( GlobalConfig->KvpncDebugLevel > 2 )
					GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: " + i18n( "'needok': %1" ).arg( i18n( "cancel" ) ), GlobalConfig->debug );

				sendToServer( "needok \"" + req + "\" cancel\n" );
			}
			socket->close();
			// if ( line.find( " >PASSWORD:", 0, FALSE ) > -1 ) {
			//
			// 			if ( GlobalConfig->KvpncDebugLevel > 2 )
			// 				GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: " + i18n( "got 'password' message" ), GlobalConfig->debug );
			//
			// 			QString req = line.section( QRegExp( ".*'(.*)'.*" ), 0, 0 ); // $1;
			// 			QCString password;
			// 			QString pass = "";
			// 			int result = KPasswordDialog::getPassword( password, QString( req + i18n( " password:" ) ) );
			// 			QTextStream os( socket );
			// 			//			os.setEncoding( QTextStream::UnicodeUTF8 );
			// 			if ( result == KPasswordDialog::Accepted ) {
			// 				if ( GlobalConfig->KvpncDebugLevel > 2 )
			// 					GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: " + i18n( "password got from user" ), GlobalConfig->debug );
			// 				pass = QString( password );
			//
			// 				pass = pass.remove( '\r' );
			// 				pass = pass.remove( '\n' );
			// 			} else {
			// 				pass = "";
			// 			}
			// 			sendToServer( "password \"" + req + "\" \"" + pass + "\"\n" );
		}
		if ( line.find( "PASSWORD:Need 'Auth' username/password", 0, FALSE ) > -1 ) {

			if ( GlobalConfig->KvpncDebugLevel > 2 )
				GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: " + i18n( "got 'need username/password' message" ), GlobalConfig->debug );

			if ( GlobalConfig->KvpncDebugLevel > 2 )
				GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: " + i18n( "Send username..." ), GlobalConfig->debug );

			if ( !GlobalConfig->currentProfile->getUserName().isEmpty()   /* && !GlobalConfig->currentProfile->getDontSaveUsername() */ ) {
				// 				if ( GlobalConfig->KvpncDebugLevel > 2 )
// 									GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: username: "+GlobalConfig->currentProfile->getUserName(), GlobalConfig->debug );

				sendToServer( "username Auth " + GlobalConfig->currentProfile->getUserName() + "\n" );

			} else {
				if ( GlobalConfig->TmpUsername.isEmpty() ) {
					bool ok=false;
					QString username = KInputDialog::getText   (   i18n("User name"),i18n("Enter username:"),"",&ok);
					QTextStream os( socket );
					//			os.setEncoding( QTextStream::UnicodeUTF8 );
					if ( ok ==true && !username.isEmpty() ) {
						if ( GlobalConfig->KvpncDebugLevel > 2 )
							GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: " + i18n( "username got from user" ), GlobalConfig->debug );
						GlobalConfig->TmpUsername = username;


						// 						if ( GlobalConfig->KvpncDebugLevel > 5 )
// 													GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: username: "+GlobalConfig->TmpUsername, GlobalConfig->debug );

						sendToServer( "username Auth " + GlobalConfig->TmpUsername + "\n" );
					} else {
						GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: username dialog canceled and username empty, stop.", GlobalConfig->info );
						emit terminate_openvpn();
					}
				} else {
					// 						if ( GlobalConfig->KvpncDebugLevel > 5 )
// 												GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: username: "+GlobalConfig->TmpUsername, GlobalConfig->debug );
					sendToServer( "username Auth " + GlobalConfig->TmpUsername + "\n" );

				}
			}
		

			if ( GlobalConfig->KvpncDebugLevel > 2 )
				GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: " + i18n( "Send password..." ), GlobalConfig->debug );

			if ( !GlobalConfig->currentProfile->getUserPassword().isEmpty()   /* && GlobalConfig->currentProfile->getSaveUserPassword()  */ ) {
				// 				if ( GlobalConfig->KvpncDebugLevel > 5 )
				// 					GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: password: " +GlobalConfig->currentProfile->getUserPassword(), GlobalConfig->debug );

				sendToServer( "password Auth " + GlobalConfig->currentProfile->getUserPassword() + "\n" );
			} else {
				if ( GlobalConfig->TmpPassword.isEmpty() ) {
					QCString password;
					QString pass = "";
					int result = KPasswordDialog::getPassword( password, QString( i18n( " password:" ) ) );
					QTextStream os( socket );
					//			os.setEncoding( QTextStream::UnicodeUTF8 );
					if ( result == KPasswordDialog::Accepted ) {
						if ( GlobalConfig->KvpncDebugLevel > 2 )
							GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: " + i18n( "password got from user" ), GlobalConfig->debug );
						GlobalConfig->TmpPassword = QString( password );


						// 						if ( GlobalConfig->KvpncDebugLevel > 5 )
						// 							GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: password: "+GlobalConfig->TmpPassword, GlobalConfig->debug );

						sendToServer( "password Auth " + GlobalConfig->TmpPassword + "\n" );
					} else {
						GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: password dialog canceled and password empty, stop.", GlobalConfig->info );
						emit terminate_openvpn();
					}
				} else {
					// 						if ( GlobalConfig->KvpncDebugLevel > 5 )
					// 							GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: password: "+GlobalConfig->TmpPassword, GlobalConfig->debug );
					sendToServer( "password Auth " + GlobalConfig->TmpPassword + "\n" );

				}
			}
		}

		// 		if ( line.find( "SUCCESS: 'Auth' username entered", 0, FALSE ) > -1 ) {
		//
		// 			if ( GlobalConfig->KvpncDebugLevel > 2 )
		// 				GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: " + i18n( "got 'need username/password' message 2. step" ), GlobalConfig->debug );
		//
		// 			if ( GlobalConfig->KvpncDebugLevel > 2 )
		// 				GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: " + i18n( "Send password..." ), GlobalConfig->debug );
		//
		// 			if (  GlobalConfig->currentProfile->getUserPassword().isEmpty() )
		// 				sendToServer( "password Auth " + GlobalConfig->TmpPassword + "\"\n" );
		// 			else
		// 				sendToServer( "password Auth " + GlobalConfig->currentProfile->getUserPassword() + "\"\n" );
		//
		// 		}
		if ( line.find( "PASSWORD:Need 'Private Key' password", 0, FALSE ) > -1 ) {

			if ( GlobalConfig->KvpncDebugLevel > 2 )
				GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: " + i18n( "got 'private key password' message" ), GlobalConfig->debug );

			if ( GlobalConfig->KvpncDebugLevel > 2 )
				GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: " + i18n( "Send private key password..." ), GlobalConfig->debug );

			if ( !GlobalConfig->currentProfile->getPrivateKeyPass().isEmpty() ) {
				// 												if ( GlobalConfig->KvpncDebugLevel > 5 )
// 				GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: password: " + GlobalConfig->TmpPrivateKeyPass, GlobalConfig->debug );

				sendToServer( "password  \"Private Key\" " + GlobalConfig->currentProfile->getPrivateKeyPass() + "\n" );
			} else {
				if ( GlobalConfig->TmpPrivateKeyPass.isEmpty() ) {
					GlobalConfig->TmpPassword="";
					QCString password;
					QString pass = "";
			
					QTextStream os( socket );
					//			os.setEncoding( QTextStream::UnicodeUTF8 );
			
					GlobalConfig->TmpPrivateKeyPass = "";
					EnterXauthInteractivePasscodeDialog dlg( 0, i18n( "Enter private key password" ) );
					dlg.main->DescriptionLabel->setText( i18n( "Enter private key password to unlock private key:" ) );
					dlg.main->LabelPassword->setText( i18n( "Private key password:" ) );
					dlg.main->SavePasswordCheckBox->setText(i18n("Save private key password"));
					if ( GlobalConfig->KvpncDebugLevel > 0 )
						GlobalConfig->appendLogEntry ( "[openvpn] " + i18n( "Password for private key requested...\n" ), GlobalConfig->debug );
					if ( dlg.exec() ) {

						pass = dlg.main->PasswordEdit->text();
						if (!pass.isEmpty())
						{
				
							if ( GlobalConfig->KvpncDebugLevel > 2 )
								GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: " + i18n( "private key password got from user" ), GlobalConfig->debug );
				
							if (dlg.main->SavePasswordCheckBox->isChecked())
							{
								GlobalConfig->currentProfile->setSavePrivateKeyPassword(true);
								GlobalConfig->currentProfile->setPrivateKeyPass(QString(pass));
							}
				
							GlobalConfig->TmpPrivateKeyPass = QString( pass );
				
							// 												if ( GlobalConfig->KvpncDebugLevel > 5 )
				// 				GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: private key password: " + GlobalConfig->TmpPrivateKeyPass, GlobalConfig->debug );
				
							if ( GlobalConfig->KvpncDebugLevel > 2 )
								GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: " + i18n( "Send private key password..." ), GlobalConfig->debug );
				
							sendToServer( "password  \"Private Key\" " + GlobalConfig->TmpPrivateKeyPass + "\n" );
						}
						else
						{
						GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: password empty, stop.", GlobalConfig->error );
						emit terminate_openvpn();
						}
					} else {
						GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: password dialog canceled and password empty, stop.", GlobalConfig->info );
						emit terminate_openvpn();
					}
				}
				else {
					sendToServer( "password  \"Private Key\" " + GlobalConfig->TmpPrivateKeyPass + "\n" );
					// 												if ( GlobalConfig->KvpncDebugLevel > 5 )
// 					{
// 					GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: private key password: " + GlobalConfig->TmpPrivateKeyPass, GlobalConfig->debug );
// 					GlobalConfig->appendLogEntry( QString("OpenvpnManagementHandler: private key password string: ") + QString("password  \"Private Key\" " + GlobalConfig->TmpPrivateKeyPass + "\n"),GlobalConfig->debug);
// 					}
				}
			}
		}

		if ( line.find( "PASSWORD:Verification Failed: 'Private Key'", 0, FALSE ) > -1 ) {

			if ( GlobalConfig->KvpncDebugLevel > 2 )
				GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: " + i18n( "wrong private key password" ), GlobalConfig->debug );

			GlobalConfig->TmpPassword="";
			QCString password;
			QString pass = "";
	
			QTextStream os( socket );
			//			os.setEncoding( QTextStream::UnicodeUTF8 );
	
			GlobalConfig->TmpPrivateKeyPass = "";
			EnterXauthInteractivePasscodeDialog dlg( 0, i18n( "Enter private key password" ) );
			dlg.main->DescriptionLabel->setText( i18n( "Enter private key password to unlock private key:" ) );
			dlg.main->LabelPassword->setText( i18n( "Private key password:" ) );
			dlg.main->SavePasswordCheckBox->setText(i18n("Save private key password"));
			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry ( "[openvpn] " + i18n( "Password for private key requested...\n" ), GlobalConfig->debug );
			if ( dlg.exec() ) {
				pass = dlg.main->PasswordEdit->text();

				if (!pass.isEmpty())
				{

					if ( GlobalConfig->KvpncDebugLevel > 2 )
						GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: " + i18n( "private key password got from user" ), GlobalConfig->debug );
	
					if (dlg.main->SavePasswordCheckBox->isChecked())
					{
						GlobalConfig->currentProfile->setSavePrivateKeyPassword(true);
						GlobalConfig->currentProfile->setPrivateKeyPass(QString(pass));
					}
	
					GlobalConfig->TmpPrivateKeyPass = QString( pass );
	
					// 												if ( GlobalConfig->KvpncDebugLevel > 5 )
	// 				GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: private key password: " + GlobalConfig->TmpPrivateKeyPass, GlobalConfig->debug );
	
					if ( GlobalConfig->KvpncDebugLevel > 2 )
						GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: " + i18n( "Send private key password..." ), GlobalConfig->debug );
	
					sendToServer( "password  \"Private Key\" " + GlobalConfig->TmpPrivateKeyPass + "\n" );
				}
				else
				{
				GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: password empty, stop.", GlobalConfig->error );
				emit terminate_openvpn();
				}
			} else {
				GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: password dialog canceled and password empty, stop.", GlobalConfig->info );
				emit terminate_openvpn();
			}
		}

		if ( line.find( "FATAL:script failed: shell command exited with error status", 0, FALSE ) > -1 ) {

			if ( GlobalConfig->KvpncDebugLevel > 2 )
				GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: script exited with wrong status" , GlobalConfig->error );

			emit terminate_openvpn();
		}


		if ( line.find( "PASSWORD:Verification Failed: 'Auth'", 0, FALSE ) > -1 ) {

			if ( GlobalConfig->KvpncDebugLevel > 2 )
				GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: password verification failed!" , GlobalConfig->error );

			GlobalConfig->appendLogEntry( i18n( "Authentication failed (%1)!" ).arg( i18n( "user password" ) ) , GlobalConfig->error );

			emit terminate_openvpn();
		}

	}
}
