#ifndef _KVI_MDI_BUTTON_H_INCLUDED_
#define _KVI_MDI_BUTTON_H_INCLUDED_

// =============================================================================
//
//      --- kvi_mdi_button.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <qframe.h>

#define KVI_CAPTION_BUTTON_ENABLED     0
#define KVI_CAPTION_BUTTON_DISABLED    1
#define KVI_CAPTION_BUTTON_HIGHLIGHTED 2

/**
 * Internal class
 * @internal
 */
class KviMdiButton : public QFrame
{
	Q_OBJECT
public:
	enum MdiButtonType { Close, Maximize, Minimize, Restore };
	KviMdiButton(QWidget *parent, MdiButtonType type, const char *name = 0);
	~KviMdiButton();
public:
	MdiButtonType m_type;
	bool m_bHighlight;
	bool m_bPressed;
public:
	void setType(MdiButtonType type);
protected:
	virtual void drawContents(QPainter *);
	virtual void enterEvent(QEvent *);
	virtual void leaveEvent(QEvent *);
	virtual void   mousePressEvent(QMouseEvent *);
	virtual void mouseReleaseEvent(QMouseEvent *);
signals:
	void buttonPressed();
};

#endif // _KVI_MDI_BUTTON_H_INCLUDED_
