#ifndef __LIBKVISTYLE_H_INCLUDED__
#define __LIBKVISTYLE_H_INCLUDED__

//
//   THIS IS A "READY TO EDIT" SOURCE FOR YOUR FIRST PLUGIN
//   Copyright (C) 1999-2000 PLACE YOUR NAME HERE (your@email)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//


#include <qplatinumstyle.h>
#include <qmotifstyle.h>


class KviBasicStyle : public QPlatinumStyle
{
	Q_OBJECT
public:
	KviBasicStyle();
	~KviBasicStyle();
protected:
	virtual void polish(QWidget * w);
	virtual void unPolish(QWidget * w);

	void drawBasicShape(GC gc,HANDLE h,const QColorGroup &g,int x1,int y1,int x2,int y2,bool bSunken,bool bEnabled,bool bSpecial,bool bDoubleBorder = true);

	virtual void drawPushButton(QPushButton * b,QPainter * p);
	virtual void drawPushButtonLabel(QPushButton * btn,QPainter * p);
	void drawPopupMenuItem( QPainter* p, bool checkable, int maxpmw, int tab, QMenuItem* mi,
				       const QPalette& pal,bool act, bool enabled, int x, int y, int w, int h);
//	virtual void drawBevelButton(QPainter *p,int x,int y,int w,int h,const QColorGroup &g,bool sunken=false,const QBrush *fill=0);
};

class KviPureStyle : public QPlatinumStyle
{
	Q_OBJECT
public:
	KviPureStyle();
	~KviPureStyle();
protected:
//	QPalette m_savedAppPalette;
protected:
	virtual void polish(QWidget * w);
	virtual void unPolish(QWidget * w);
	virtual void polish(QPalette &pal);
	void drawPopupMenuItem( QPainter* p, bool checkable, int maxpmw, int tab, QMenuItem* mi,
				       const QPalette& pal,bool act, bool enabled, int x, int y, int w, int h);
};

class KviWoodStyle : public QMotifStyle
{
	Q_OBJECT
public:
    KviWoodStyle();
	~KviWoodStyle();

    void polish(QPalette &pal);
    void polish( QWidget* );
    void unPolish( QWidget* );
//    void unPolish( QApplication*);

    void drawButton( QPainter *p, int x, int y, int w, int h,
			     const QColorGroup &g, bool sunken = FALSE,
			     const QBrush *fill = 0 );
    void drawBevelButton( QPainter *p, int x, int y, int w, int h,
			  const QColorGroup &g, bool sunken = FALSE,
			  const QBrush *fill = 0 );
    QRect buttonRect( int x, int y, int w, int h);
    void drawButtonMask( QPainter *p, int x, int y, int w, int h);


    void drawPushButton( QPushButton* btn, QPainter *p);
    void drawPushButtonLabel( QPushButton* btn, QPainter *p);
    
//private:
//    QPalette oldPalette;
};

#endif //!__LIBKVISTYLE_H_INCLUDED__
