/**vim: ts=4, wrap, tw=80
  *
  *		--- libkvistatwindow.cpp ---
  *
  * This is a plugin for KVirc 2.0 Phoenix. It allows you to see
  * statistics of your IRC sessions - total words said etc.
  * More features are still to come.
  *
  * (c) Krzysztof Godlewski <kristoff@poczta.wprost.pl>
  *
  * 
  * This program is FREE software. You can redistribute it and/or
  * modify it under the terms of the GNU General Public License
  * as published by the Free Software Foundation; either version 2
  * of the License, or (at your opinion) any later version.
  *
  * This program is distributed in the HOPE that it will be USEFUL,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  * See the GNU General Public License for more details.

  * You should have received a copy of the GNU General Public License
  * along with this program. If not, write to the Free Software Foundation,
  * Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
  **/


#include <qpushbutton.h>
#include <qmessagebox.h>

#include "libkvistatwindow.h"
#include "libkvistatsystraywidget.h"
#include "libkvistat.h"

#include "kvi_locale.h"

extern KviStatController * g_pStatPluginController;

KviStatWindow::KviStatWindow() : QTabDialog(0, "KviStatWindow", false )
{
	QString cap;
	cap.sprintf(__tr("Stats since %s"),
		g_pStatPluginController->statData().startDate.ptr());
	setCaption(cap);
	labels.setAutoDelete(true);

	QVBox *vb = new QVBox(this);
	vb->setMargin(5);
	vb->resize( 290, 270 );

	setFixedSize( vb->width() + 20, vb->height() + 20 );

	int lab_count = 0;
//
// Words / letters tab
	for( ; lab_count < 8; lab_count++ )
	{
		labels.append(new QLabel(vb));
		labels.at(lab_count)->setTextFormat(PlainText);
	}

	addTab(vb, _CHAR_2_QSTRING(__tr("Words/Letters")));
//
// Chanlist
	vb = new QVBox(this);
	vb->setMargin(5);
	m_chansView = new QListView(vb);

	const char *columns[] = { __tr("Name"), __tr("Joins"), __tr("Words"), __tr("Kicks"), __tr("Bans"), __tr("Topics")};

#define Col_Name		0
#define Col_Joins		1
#define Col_Words		2
#define Col_Kicks		3
#define Col_Bans		4
#define Col_Topics		5

	for( uint i = 0; i < sizeof(columns) / sizeof(columns[0]); i++ )
		m_chansView->addColumn(_CHAR_2_QSTRING(columns[i]));

	m_chansView->setColumnWidth( Col_Name, 62 );

	QHBox *hb = new QHBox(vb);
	hb->setMargin(5);
	hb->setSpacing(10);

	QPushButton *b = new QPushButton( _CHAR_2_QSTRING(__tr("Remove channel")), hb );
	connect(b, SIGNAL(clicked()), SLOT(slotRemoveChan()));

	b = new QPushButton( _CHAR_2_QSTRING(__tr("Remove all")), hb );
	connect( b, SIGNAL(clicked()), g_pStatPluginController,
		SLOT(slotRemoveAllChans()));

	addTab(vb,_CHAR_2_QSTRING(__tr("Channels")));

//
// Misc
	vb = new QVBox(this);
	vb->setMargin(5);

	for( ; lab_count < 14; lab_count++ )
	{
		labels.append(new QLabel(vb));
		labels.at(lab_count)->setTextFormat(PlainText);
	}

	addTab(vb, _CHAR_2_QSTRING(__tr( "Misc")));
	
	setDefaultButton( _CHAR_2_QSTRING(__tr( "Reset")));
	connect( this, SIGNAL(defaultButtonPressed()), g_pStatPluginController,
		SLOT(slotReset()));

	updateStats();
}

KviStatWindow::~KviStatWindow()
{
}

void KviStatWindow::updateStats()
{
	const KviStatData sd = g_pStatPluginController->statData();

//
// Words/Letters
/* Ugly... but only this way can I make qt display iso8859-2 (and others) correctly I think.
 * s.local8Bit() doesn't seem to work... */
	QString s;
	QString n;
	s = _CHAR_2_QSTRING(__tr("Total Words:\t\t\t"));
	n.sprintf("%i.", sd.totalWords);
	labels.at(0)->setText(s+n);
	s = _CHAR_2_QSTRING(__tr("Total Letters:\t\t\t"));
	n.sprintf("%i.",sd.totalLetters );
	labels.at(1)->setText(s+n);
	s = _CHAR_2_QSTRING(__tr("Channels Words:\t\t\t"));
	n.sprintf("%i.",sd.chansWords );
	labels.at(2)->setText(s+n);
	s = _CHAR_2_QSTRING( __tr("Channels Letters:\t\t"));
	n.sprintf("%i.", sd.chansLetters );
	labels.at(3)->setText(s+n);
	s = _CHAR_2_QSTRING( __tr("Queries Words:\t\t\t"));
	n.sprintf("%i.", sd.queriesWords );
	labels.at(4)->setText(s+n);
	s = _CHAR_2_QSTRING( __tr("Queries Letters:\t\t\t"));
	n.sprintf("%i.", sd.queriesLetters );
	labels.at(5)->setText(s+n);
	s = _CHAR_2_QSTRING( __tr("DCCs Words:\t\t\t"));
	n.sprintf("%i.", sd.dccsWords );
	labels.at(6)->setText(s+n);
	s = _CHAR_2_QSTRING( __tr("DCCs Letters:\t\t\t"));
	n.sprintf("%i.", sd.dccsLetters );
	labels.at(7)->setText(s+n);

//
// Misc
	s = _CHAR_2_QSTRING( __tr("Number of IRC sessions:\t\t"));
	n.sprintf("%i.", sd.onIrc);
	labels.at(8)->setText(s+n);
	s = _CHAR_2_QSTRING( __tr("Words Record:\t\t\t"));
	n.sprintf("%i.", sd.wordsRecord );
	labels.at(9)->setText(s+n);
	s = _CHAR_2_QSTRING( __tr("Number of kicks given:\t\t"));
	n.sprintf("%i.", sd.kicks );
	labels.at(10)->setText(s+n);
	s = _CHAR_2_QSTRING( __tr("Number of bans set:\t\t"));
	n.sprintf("%i.", sd.bans );
	labels.at(11)->setText(s+n);
	s = _CHAR_2_QSTRING( __tr("Number of joins to channels:\t"));
	n.sprintf("%i.", sd.joins );
	labels.at(12)->setText(s+n);
	s = _CHAR_2_QSTRING( __tr("Number of topic changes:\t\t"));
	n.sprintf("%i.", sd.topics );
	labels.at(13)->setText(s+n);

//
// Channels
	m_chansView->clear();
	for( const KviStatChan *c = g_pStatPluginController->chanList()->first();
		c; c = g_pStatPluginController->chanList()->next() )
	{
		QListViewItem *vi = new QListViewItem( m_chansView );
		vi->setText(Col_Name, c->name() );
		vi->setText(Col_Words, s.setNum(c->words()));
		vi->setText(Col_Joins, s.setNum(c->joins()));
		vi->setText(Col_Kicks, s.setNum(c->kicks()));
		vi->setText(Col_Bans,  s.setNum(c->bans()));
		vi->setText(Col_Topics,s.setNum(c->topics()));
		m_chansView->insertItem(vi);
	}

	m_chansView->setSorting( Col_Words );
}

void KviStatWindow::slotRemoveChan()
{
	if( ! m_chansView->selectedItem() )
		return;

	KviStr cn = m_chansView->selectedItem()->text(Col_Name).latin1();
	if( QMessageBox::warning( 0,_CHAR_2_QSTRING(__tr("Remove Channel")),
	_CHAR_2_QSTRING(__tr("Are you sure you want to remove this channel from your statistics ?")),
	_CHAR_2_QSTRING(__tr("Yes")), _CHAR_2_QSTRING(__tr("No")), 0, 1) == 0 )	// def. button: No( == 1)
	{
		KviStatChan *chan = g_pStatPluginController->findStatChan(cn.ptr());
		m_chansView->removeItem( m_chansView->selectedItem() );
		g_pStatPluginController->removeChan(chan);
	}
}

#include "libkvistatwindow.moc"
