//
//   SPEAK plugin for KVirc 1.1 Phoenix.
//
//   This plugin enables you to use IBM's ViaVoiceOutloud to speak
//   messages to you.  Messages that are directed to you, over the
//   Relay Chat, can be spoken outloud or sentences spoken by specific
//   people can also heard outloud.
//
//   To use the plugin, one needs to have a working IBM ViaVoice
//   Outloud, which can be retrieved from IBM's site.  For information
//   about IBM ViaVoice http://www-4.ibm.com/software/speech/dev/
//
//   Copyright (C) rn E. Hansen (oe.hansen@gamma.telenordia.se)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include <qpixmap.h>
#include <qlayout.h>
#include "smileyClassData.h"

#include "kvi_locale.h"

#include <qlabel.h>
#include <qpushbutton.h>

smileyClassData::smileyClassData(QWidget *parent, const char *name)
                : QDialog(parent, name, TRUE, 0)
{
    m_pShortHands = new QListView(this, "ListView_1");
    m_pShortHands->setGeometry(15, 130, 405, 135);
    m_pShortHands->setMinimumSize(0, 0);
    m_pShortHands->setMaximumSize(32767, 32767);
    m_pShortHands->setFocusPolicy(QWidget::TabFocus);
    m_pShortHands->setBackgroundMode(QWidget::PaletteBackground);
    m_pShortHands->setFontPropagation(QWidget::SameFont);
    m_pShortHands->setPalettePropagation(QWidget::SameFont);
    m_pShortHands->setFrameStyle( 48 );
    m_pShortHands->setLineWidth( 2 );
    m_pShortHands->setMidLineWidth( 0 );
    m_pShortHands->QFrame::setMargin( 0 );
    m_pShortHands->setResizePolicy( QScrollView::Manual );
    m_pShortHands->setVScrollBarMode( QScrollView::Auto );
    m_pShortHands->setHScrollBarMode( QScrollView::Auto );
    m_pShortHands->setTreeStepSize( 20 );
    m_pShortHands->setMultiSelection( FALSE );
    m_pShortHands->setAllColumnsShowFocus( FALSE );
    m_pShortHands->setItemMargin( 1 );
    m_pShortHands->setRootIsDecorated( FALSE );
    m_pShortHands->addColumn( __tr( "Short hand" ), -1 );
    m_pShortHands->setColumnWidthMode( 0, QListView::Maximum );
    m_pShortHands->setColumnAlignment( 0, 1 );
    m_pShortHands->addColumn( __tr( "CS" ), -1 );
    m_pShortHands->setColumnWidthMode( 1, QListView::Maximum );
    m_pShortHands->setColumnAlignment( 1, 1 );
    m_pShortHands->addColumn( __tr( "Spoken text" ), -1 );
    m_pShortHands->setColumnWidthMode( 2, QListView::Maximum );
    m_pShortHands->setColumnAlignment( 2, 1 );
    connect(m_pShortHands, SIGNAL(currentChanged(QListViewItem*)), SLOT(selectShortHand(QListViewItem*)));

    m_pShortText = new QLineEdit(this, "LineEdit_1");
    m_pShortText->setGeometry(115, 25, 110, 20);
    m_pShortText->setMinimumSize(0, 0);
    m_pShortText->setMaximumSize(32767, 32767);
    m_pShortText->setFocusPolicy(QWidget::StrongFocus);
    m_pShortText->setBackgroundMode(QWidget::PaletteBase);
    m_pShortText->setFontPropagation(QWidget::SameFont);
    m_pShortText->setPalettePropagation(QWidget::SameFont);
    m_pShortText->setText( "" );
    m_pShortText->setMaxLength( 32767 );
    m_pShortText->setFrame( QLineEdit::Normal );
    m_pShortText->setFrame( TRUE );
    m_pShortText->setAlignment( AlignLeft );

    m_pSpokenText = new QLineEdit(this, "LineEdit_2");
    m_pSpokenText->setGeometry(115, 60, 280, 20);
    m_pSpokenText->setMinimumSize(0, 0);
    m_pSpokenText->setMaximumSize(32767, 32767);
    m_pSpokenText->setFocusPolicy(QWidget::StrongFocus);
    m_pSpokenText->setBackgroundMode(QWidget::PaletteBase);
    m_pSpokenText->setFontPropagation(QWidget::SameFont);
    m_pSpokenText->setPalettePropagation(QWidget::SameFont);
    m_pSpokenText->setText( "" );
    m_pSpokenText->setMaxLength( 32767 );
    m_pSpokenText->setFrame( QLineEdit::Normal );
    m_pSpokenText->setFrame( TRUE );
    m_pSpokenText->setAlignment( AlignLeft );

    m_pCaseSensation = new QCheckBox(this, "CheckBox_1");
    m_pCaseSensation->setGeometry(285, 30, 105, 15);
    m_pCaseSensation->setMinimumSize(0, 0);
    m_pCaseSensation->setMaximumSize(32767, 32767);
    m_pCaseSensation->setFocusPolicy(QWidget::TabFocus);
    m_pCaseSensation->setBackgroundMode(QWidget::PaletteBackground);
    m_pCaseSensation->setFontPropagation(QWidget::SameFont);
    m_pCaseSensation->setPalettePropagation(QWidget::SameFont);
    m_pCaseSensation->setText( __tr( "&Case sensitive" ) );
    m_pCaseSensation->setAutoRepeat( FALSE );
    m_pCaseSensation->setAutoResize( FALSE );
    m_pCaseSensation->setChecked( FALSE );

    QLabel *qtarch_Label_1 = new QLabel(this, "Label_1");
    qtarch_Label_1->setGeometry(15, 30, 95, 15);
    qtarch_Label_1->setMinimumSize(0, 0);
    qtarch_Label_1->setMaximumSize(32767, 32767);
    qtarch_Label_1->setFocusPolicy(QWidget::NoFocus);
    qtarch_Label_1->setBackgroundMode(QWidget::PaletteBackground);
    qtarch_Label_1->setFontPropagation(QWidget::SameFont);
    qtarch_Label_1->setPalettePropagation(QWidget::SameFont);
    qtarch_Label_1->setFrameStyle( 0 );
    qtarch_Label_1->setLineWidth( 1 );
    qtarch_Label_1->setMidLineWidth( 0 );
    qtarch_Label_1->QFrame::setMargin( 0 );
    qtarch_Label_1->setText( __tr( "Short hand:" ) );
    qtarch_Label_1->setAlignment( AlignRight|AlignVCenter|ExpandTabs );
    qtarch_Label_1->setMargin( 0 );

    QLabel *qtarch_Label_2 = new QLabel(this, "Label_2");
    qtarch_Label_2->setGeometry(30, 65, 80, 15);
    qtarch_Label_2->setMinimumSize(0, 0);
    qtarch_Label_2->setMaximumSize(32767, 32767);
    qtarch_Label_2->setFocusPolicy(QWidget::NoFocus);
    qtarch_Label_2->setBackgroundMode(QWidget::PaletteBackground);
    qtarch_Label_2->setFontPropagation(QWidget::SameFont);
    qtarch_Label_2->setPalettePropagation(QWidget::SameFont);
    qtarch_Label_2->setFrameStyle( 0 );
    qtarch_Label_2->setLineWidth( 1 );
    qtarch_Label_2->setMidLineWidth( 0 );
    qtarch_Label_2->QFrame::setMargin( 0 );
    qtarch_Label_2->setText( __tr( "Speak as:" ) );
    qtarch_Label_2->setAlignment( AlignRight|AlignVCenter|ExpandTabs );
    qtarch_Label_2->setMargin( 0 );

    QPushButton *qtarch_PushButton_1 = new QPushButton(this, "PushButton_1");
    qtarch_PushButton_1->setGeometry(20, 100, 80, 20);
    qtarch_PushButton_1->setMinimumSize(0, 0);
    qtarch_PushButton_1->setMaximumSize(32767, 32767);
    qtarch_PushButton_1->setFocusPolicy(QWidget::TabFocus);
    qtarch_PushButton_1->setBackgroundMode(QWidget::PaletteButton);
    qtarch_PushButton_1->setFontPropagation(QWidget::SameFont);
    qtarch_PushButton_1->setPalettePropagation(QWidget::SameFont);
    qtarch_PushButton_1->setText( __tr( "&Insert" ) );
    qtarch_PushButton_1->setAutoRepeat( FALSE );
    qtarch_PushButton_1->setAutoResize( FALSE );
    qtarch_PushButton_1->setToggleButton( FALSE );
    qtarch_PushButton_1->setDefault( FALSE );
    qtarch_PushButton_1->setAutoDefault( FALSE );
    qtarch_PushButton_1->setIsMenuButton( FALSE );
    connect(qtarch_PushButton_1, SIGNAL(clicked()), SLOT(insertItem()));

    QPushButton *qtarch_PushButton_2 = new QPushButton(this, "PushButton_2");
    qtarch_PushButton_2->setGeometry(115, 100, 85, 20);
    qtarch_PushButton_2->setMinimumSize(0, 0);
    qtarch_PushButton_2->setMaximumSize(32767, 32767);
    qtarch_PushButton_2->setFocusPolicy(QWidget::TabFocus);
    qtarch_PushButton_2->setBackgroundMode(QWidget::PaletteButton);
    qtarch_PushButton_2->setFontPropagation(QWidget::SameFont);
    qtarch_PushButton_2->setPalettePropagation(QWidget::SameFont);
    qtarch_PushButton_2->setText( __tr( "&Delete" ) );
    qtarch_PushButton_2->setAutoRepeat( FALSE );
    qtarch_PushButton_2->setAutoResize( FALSE );
    qtarch_PushButton_2->setToggleButton( FALSE );
    qtarch_PushButton_2->setDefault( FALSE );
    qtarch_PushButton_2->setAutoDefault( FALSE );
    qtarch_PushButton_2->setIsMenuButton( FALSE );
    connect(qtarch_PushButton_2, SIGNAL(clicked()), SLOT(removeItem()));

    QPushButton *qtarch_PushButton_3 = new QPushButton(this, "PushButton_3");
    qtarch_PushButton_3->setGeometry(10, 280, 100, 25);
    qtarch_PushButton_3->setMinimumSize(0, 0);
    qtarch_PushButton_3->setMaximumSize(32767, 32767);
    qtarch_PushButton_3->setFocusPolicy(QWidget::TabFocus);
    qtarch_PushButton_3->setBackgroundMode(QWidget::PaletteButton);
    qtarch_PushButton_3->setFontPropagation(QWidget::SameFont);
    qtarch_PushButton_3->setPalettePropagation(QWidget::SameFont);
    qtarch_PushButton_3->setText( __tr( "&OK" ) );
    qtarch_PushButton_3->setAutoRepeat( FALSE );
    qtarch_PushButton_3->setAutoResize( FALSE );
    qtarch_PushButton_3->setToggleButton( FALSE );
    qtarch_PushButton_3->setDefault( FALSE );
    qtarch_PushButton_3->setAutoDefault( FALSE );
    qtarch_PushButton_3->setIsMenuButton( FALSE );
    connect(qtarch_PushButton_3, SIGNAL(clicked()), SLOT(okPressed()));

    QPushButton *qtarch_PushButton_4 = new QPushButton(this, "PushButton_4");
    qtarch_PushButton_4->setGeometry(310, 100, 85, 20);
    qtarch_PushButton_4->setMinimumSize(0, 0);
    qtarch_PushButton_4->setMaximumSize(32767, 32767);
    qtarch_PushButton_4->setFocusPolicy(QWidget::TabFocus);
    qtarch_PushButton_4->setBackgroundMode(QWidget::PaletteButton);
    qtarch_PushButton_4->setFontPropagation(QWidget::SameFont);
    qtarch_PushButton_4->setPalettePropagation(QWidget::SameFont);
    qtarch_PushButton_4->setText( __tr( "&Update" ) );
    qtarch_PushButton_4->setAutoRepeat( FALSE );
    qtarch_PushButton_4->setAutoResize( FALSE );
    qtarch_PushButton_4->setToggleButton( FALSE );
    qtarch_PushButton_4->setDefault( FALSE );
    qtarch_PushButton_4->setAutoDefault( FALSE );
    qtarch_PushButton_4->setIsMenuButton( FALSE );
    connect(qtarch_PushButton_4, SIGNAL(clicked()), SLOT(updateItem()));

    QPushButton *qtarch_PushButton_5 = new QPushButton(this, "PushButton_5");
    qtarch_PushButton_5->setGeometry(245, 280, 80, 25);
    qtarch_PushButton_5->setMinimumSize(0, 0);
    qtarch_PushButton_5->setMaximumSize(32767, 32767);
    qtarch_PushButton_5->setFocusPolicy(QWidget::TabFocus);
    qtarch_PushButton_5->setBackgroundMode(QWidget::PaletteButton);
    qtarch_PushButton_5->setFontPropagation(QWidget::SameFont);
    qtarch_PushButton_5->setPalettePropagation(QWidget::SameFont);
    qtarch_PushButton_5->setText( __tr( "&Save as" ) );
    qtarch_PushButton_5->setAutoRepeat( FALSE );
    qtarch_PushButton_5->setAutoResize( FALSE );
    qtarch_PushButton_5->setToggleButton( FALSE );
    qtarch_PushButton_5->setDefault( FALSE );
    qtarch_PushButton_5->setAutoDefault( FALSE );
    qtarch_PushButton_5->setIsMenuButton( FALSE );
    connect(qtarch_PushButton_5, SIGNAL(clicked()), SLOT(saveBaseAs()));

    QPushButton *qtarch_PushButton_6 = new QPushButton(this, "PushButton_6");
    qtarch_PushButton_6->setGeometry(335, 280, 80, 25);
    qtarch_PushButton_6->setMinimumSize(0, 0);
    qtarch_PushButton_6->setMaximumSize(32767, 32767);
    qtarch_PushButton_6->setFocusPolicy(QWidget::TabFocus);
    qtarch_PushButton_6->setBackgroundMode(QWidget::PaletteButton);
    qtarch_PushButton_6->setFontPropagation(QWidget::SameFont);
    qtarch_PushButton_6->setPalettePropagation(QWidget::SameFont);
    qtarch_PushButton_6->setText( __tr( "&Load" ) );
    qtarch_PushButton_6->setAutoRepeat( FALSE );
    qtarch_PushButton_6->setAutoResize( FALSE );
    qtarch_PushButton_6->setToggleButton( FALSE );
    qtarch_PushButton_6->setDefault( FALSE );
    qtarch_PushButton_6->setAutoDefault( FALSE );
    qtarch_PushButton_6->setIsMenuButton( FALSE );
    connect(qtarch_PushButton_6, SIGNAL(clicked()), SLOT(loadBase()));

    resize(435,315);
    setMinimumSize(0, 0);
    setMaximumSize(32767, 32767);
}

smileyClassData::~smileyClassData()
{
}
