#ifndef _KVI_SPARSER_H_INCLUDED_
#define _KVI_SPARSER_H_INCLUDED_

//
//   File : kvi_sparser.h (/usr/build/NEW_kvirc/kvirc/src/kvirc/kvi_sparser.h)
//   Last major modification : Wed Feb 10 1999 19:13:55 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include <qobject.h>
#include <qlist.h>

#include "kvi_string.h"


class KviFrame;
class KviIrcSocket;
class KviConsole;
class KviStatusBar;
class KviIrcUser;
class KviChannel;
class KviWindow;
class KviUserParser;

// forward decl
typedef struct KviRawEventStruct KviRawEvent;

typedef struct KviIrcMessage
{
	KviStr szPrefix;
	KviStr szCommand;
	unsigned int    uCommand;
	KviStr szParams;
	bool   bHasBeenHandled; // Has been handled by a script
};

class KviServerParser;

typedef void (KviServerParser::*ircCmdParseProc) (KviIrcMessage *);

typedef struct KviIrcCommandEntry
{
	const char *     cmdName;
	int              cmdLen;
	ircCmdParseProc  cmdProc;
};

typedef void (KviServerParser::*ctcpRequestParseProc) (KviIrcUser &,const char *,const char *);

typedef struct KviCtcpCommandEntry
{
	const char *          ctcpName;
	int                   ctcpLen;
	char                  bCausesFlood;
	ctcpRequestParseProc  ctcpProc;
	ctcpRequestParseProc  ctcpReplyProc;
};

class KviServerParser : public QObject
{
	friend class KviIrcSocket;
	friend class KviFrame;
	Q_OBJECT
protected:
	KviServerParser(KviFrame *pFrm);
	~KviServerParser();
private:
	KviFrame                  *m_pFrm;
	KviIrcSocket              *m_pSocket;
	KviConsole                *m_pConsole;
	KviStatusBar              *m_pStatus;
	KviUserParser             *m_pUserParser;
	static KviIrcCommandEntry cmdTable[];
	static KviCtcpCommandEntry ctcpCmdTable[];
	int m_iCtcpTimerId;
	int m_iCtcpCount;
	int m_iQueryTimerId;
	int m_iQueryCount;
	KviStr                     m_szLastNetsplit;
	int                        m_iNetsplitTimerId;
protected:
	void setup(KviIrcSocket *pSock,KviConsole *pConsole,KviUserParser *pUParser);

	bool isMe(const KviIrcUser &user);
	bool isMe(const char *nick);

	const char * skipToTrailing(const char *str);
	const char * skipWord(const char *str);
	const char * skipToUsername(const char *str);

	void getDateTimeStringFromCharTimeT(KviStr &buffer,const char *time_t_string);

	void parseMessage(char *msg_buffer); //Called directly from KviIrcSocket
	bool triggerRawEvent(KviIrcMessage *msg,QList<KviRawEvent> * lp);

	void parseNumericMessage(KviIrcMessage *msg);
	void parseLiteralMessage(KviIrcMessage *msg);

	void parseNumeric000_199(KviIrcMessage *msg);
	void parseNumeric200_399(KviIrcMessage *msg);
	void parseNumeric400_999(KviIrcMessage *msg);

	void parseNumericTopic(KviIrcMessage *msg);
	void parseNumericCreationTime(KviIrcMessage *msg);
	void parseNumericEndOfNames(KviIrcMessage *msg);
	void parseNumericNamesReply(KviIrcMessage *msg);
	void parseNumericChannelMode(KviIrcMessage *msg);
	void parseNumericBanList(KviIrcMessage *msg);
	void parseNumericExceptionList(KviIrcMessage *msg);
	void parseNumericInviteList(KviIrcMessage *msg);
	void parseNumericWhoReply(KviIrcMessage *msg);
	void parseNumericUserhost(KviIrcMessage *msg);
	void parseNumericWhoisReply(KviIrcMessage *msg);
	void parseNumericWatchList(KviIrcMessage *msg);
	void parseNumericIsonReply(KviIrcMessage *msg);
	void parseNumericLinks(KviIrcMessage *msg);
	void parseNumericList(KviIrcMessage *msg);
	void parseNumericVersion(KviIrcMessage *msg);
	void parseNumericMyInfo(KviIrcMessage *msg);

	void parseNumericErrorUnknownModeChar(KviIrcMessage *msg);
	void parseNumericErrorUnknownCommand(KviIrcMessage *msg);

	void parseUnhandledNumeric(KviIrcMessage *msg);
	void parseUnhandledNumericError(KviIrcMessage *msg);

	void parseJoin(KviIrcMessage *msg);
	void parsePing(KviIrcMessage *msg);
	void parsePart(KviIrcMessage *msg);
	void parseKick(KviIrcMessage *msg);
	void parseQuit(KviIrcMessage *msg);
	void parseMode(KviIrcMessage *msg);
	void parsePrivmsg(KviIrcMessage *msg);
	void parseNick(KviIrcMessage *msg);
	void parseTopic(KviIrcMessage *msg);
	void parseNotice(KviIrcMessage *msg);
	void parseInvite(KviIrcMessage *msg);
	void parseLocops(KviIrcMessage *msg);
	void parseGlobops(KviIrcMessage *msg);
	void parseWallops(KviIrcMessage *msg);
	void parseError(KviIrcMessage *msg);

	void handleChanUserMode(KviIrcMessage *msg,KviChannel *chan,bool bAdd,char mode,const char *src_nick,
			const char *src_mask,const char *dst_nick);
	bool callChanUserModeEvent(KviChannel *chan,int event,const char *src_nick,
			const char *src_mask,const char *dst_nick,bool isme=false,char mode=0,bool bAdd=false,const char *param=0);
	void handleChanMode(KviIrcMessage *msg,KviChannel *chan,bool bAdd,char mode,const char *src_nick,
			const char *src_mask,const char *param);

	void parseUnhandledLiteral(KviIrcMessage *msg);

	// kvi_sparser.ctcp.cpp
	void parseCTCPPrivmsg(KviIrcUser &source,const char *target,const char *data);
	void parseCTCPNotice(KviIrcUser &source,const char *target,const char *data);

	void replyCTCP(const char *to,const char *type,const char *msg);

	void handleCTCPPingRequest(KviIrcUser &source,const char *target,const char *data);
	void handleCTCPVersionRequest(KviIrcUser &source,const char *target,const char *data);
	void handleCTCPTimeRequest(KviIrcUser &source,const char *target,const char *data);
	void handleCTCPUserinfoRequest(KviIrcUser &source,const char *target,const char *data);
	void handleCTCPClientinfoRequest(KviIrcUser &source,const char *target,const char *data);
	void handleCTCPSourceRequest(KviIrcUser &source,const char *target,const char *data);
	void handleCTCPDccRequest(KviIrcUser &source,const char *target,const char *data);
	void handleCTCPFingerRequest(KviIrcUser &source,const char *target,const char *data);
	void handleCTCPActionRequest(KviIrcUser &source,const char *target,const char *data);
	void handleCTCPPageRequest(KviIrcUser &source,const char *target,const char *data);
//	void handleCTCPSoundRequest(KviIrcUser &source,const char *target,const char *data);
	void handleCTCPErrmsgRequest(KviIrcUser &source,const char *target,const char *data);
	void handleCTCPMultimediaRequest(KviIrcUser &source,const char *target,const char *data);

	void handleCTCPPingReply(KviIrcUser &source,const char *target,const char *data);
	void handleCTCPVersionReply(KviIrcUser &source,const char *target,const char *data);
	void handleCTCPTimeReply(KviIrcUser &source,const char *target,const char *data);
	void handleCTCPUserinfoReply(KviIrcUser &source,const char *target,const char *data);
	void handleCTCPClientinfoReply(KviIrcUser &source,const char *target,const char *data);
	void handleCTCPSourceReply(KviIrcUser &source,const char *target,const char *data);
	void handleCTCPDccReply(KviIrcUser &source,const char *target,const char *data);
	void handleCTCPFingerReply(KviIrcUser &source,const char *target,const char *data);
	void handleCTCPActionReply(KviIrcUser &source,const char *target,const char *data);
	void handleCTCPPageReply(KviIrcUser &source,const char *target,const char *data);
//	void handleCTCPSoundReply(KviIrcUser &source,const char *target,const char *data);
	void handleCTCPErrmsgReply(KviIrcUser &source,const char *target,const char *data);
	void handleCTCPMultimediaReply(KviIrcUser &source,const char *target,const char *data);

	bool doActionEvent(KviIrcUser &source,const char *target,KviWindow *pOut,char create_query='0',const char *data=NULL);
	bool doMultimediaEvent(KviIrcUser &source,const char *target,KviWindow *pOut,int create_query,const char *filename);
	bool doCTCPEvent(const char *ctcpName,KviIrcUser &source,const char *target,bool bIgnore,KviWindow *pOut,const char *parms=NULL);
	bool doCTCPReplyEvent(const char *ctcpName,KviIrcUser &source,const char *target,KviWindow *pOut,const char *data=NULL);
	bool doCTCPFloodEvent(const char *ctcpName,KviIrcUser &source,const char *target,KviWindow *pOut,const char *parms=NULL);

	bool showCTCPRequest(const char *ctcpName,KviIrcUser &source,const char *target,bool bIgnore);
	void showCTCPReply(const char *ctcpName,KviIrcUser &source,const char *target,const char *data);

protected:
	virtual void timerEvent(QTimerEvent *e);
};

#endif //!_KVI_SPARSER_H_INCLUDED_
