#ifndef _KVI_SCRIPTMISC_H_INCLUDED_
#define _KVI_SCRIPTMISC_H_INCLUDED_

//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_scriptobject.h"

#include "kvi_dns.h"


#include <qfile.h>

class KviScriptDns : public KviScriptObject
{
	Q_OBJECT
	public:
		KviScriptDns(KviScriptObjectController * cntrl,KviScriptObject * p,const char *name,KviScriptObjectClassDefinition * pDef);
		~KviScriptDns();
	protected:
		KviDnsStruct * m_pDnsStruct;
		KviAsyncDns * m_pDns;
		bool m_bIpV6;
	public:
		static void initializeClassDefinition(KviScriptObjectClassDefinition *d);
		int builtinFunction_RESOLVE(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_ISRUNNING(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_SETMODE(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_ABORT(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_QUERY(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_HOSTNAME(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_IP(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_ALIAS1(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_ALIAS2(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_SUCCESS(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_LASTERROR(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_MODE(QList<KviStr> * params,KviStr &buffer);
	protected slots:
		void dnsFinished(KviDnsStruct * dns);
};

class KviScriptTimer : public KviScriptObject
{
	Q_OBJECT
	public:
		KviScriptTimer(KviScriptObjectController * cntrl,KviScriptObject * p,const char *name,KviScriptObjectClassDefinition * pDef);
		~KviScriptTimer();
	protected:
		int m_iTimerId;
		int m_iTimeout;
		bool m_bSingleShot;
		bool m_bAutoDestroyAfterSingleShot;
	public:
		static void initializeClassDefinition(KviScriptObjectClassDefinition *d);
		int builtinFunction_START(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_ISRUNNING(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_SINGLESHOT(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_INTERVAL(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_STOP(QList<KviStr> * params,KviStr &buffer);
	protected:
		virtual void timerEvent(QTimerEvent *e);
};

class KviScriptFile : public KviScriptObject
{
	Q_OBJECT
	public:
		KviScriptFile(KviScriptObjectController * cntrl,KviScriptObject * p,const char *name,KviScriptObjectClassDefinition * pDef);
		~KviScriptFile();
	protected:
		QFile * m_pFile;
	public:
		static void initializeClassDefinition(KviScriptObjectClassDefinition *d);
		bool init(QList<KviStr> * params);
		int builtinFunction_SETFILENAME(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_FILENAME(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_OPEN(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_CLOSE(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_FLUSH(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_SIZE(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_EXISTS(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_REMOVE(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_ISEOF(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_POS(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_SEEK(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_WRITE(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_WRITEHEX(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_READ(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_READHEX(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_READLINE(QList<KviStr> * params,KviStr &buffer);
};

#endif //_KVI_SCRIPTMISC_H_INCLUDED_

