#ifndef _KVI_HELPWINDOW_H_INCLUDED_
#define _KVI_HELPWINDOW_H_INCLUDED_

//
//   File : kvi_helpwindow.h (/usr/build/NEW_kvirc/kvirc/src/kvirc/kvi_helpwindow.h)
//   Last major modification : Thu Feb 11 1999 20:06:34 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include <qtoolbutton.h>
#include <qwidget.h>
#include <qlineedit.h>
#include <qtoolbar.h>

class KviProcess;
class KviFrame;
class QTextBrowser;

class KviHelpWindow : public QWidget
{
	Q_OBJECT
public:		// Consruction & Destruction
	KviHelpWindow(KviFrame * pFrm,QWidget * parent = 0,const char * name = 0);
	~KviHelpWindow();
public:		// Fields
	QTextBrowser * m_pBrowser;
	QToolBar     * m_pToolBar;
	QToolButton * m_pHome;
	QToolButton * m_pBack;
	QToolButton * m_pForward;
	QLineEdit   * m_pSearchString;
	QToolButton * m_pExactSearch;
	QToolButton * m_pClose;
	KviFrame    * m_pFrame;
	KviProcess  * m_pSearchJob;
public:		// Methods
	void setDocument(const char *topic);
	void doExactSearchForString(const char *str);
public slots:
	void showIndex();
	void backwardAvailable(bool bAvailable);
	void forwardAvailable(bool bAvailable);
	void reloadDocument();
	void resetStyleSheet();
	void doExactSearch();
	void copyToClipboard();
	void searchJobTerminated(KviProcess * proc,int stat);
	void closeWindow();
protected:	// Protected methods
	void createBrowser();
//	virtual QPixmap * myIconPtr();
	virtual void resizeEvent(QResizeEvent *);
//	virtual void closeEvent(QCloseEvent *e);
//	virtual void output(int msg_type,const char * format,...);
//	virtual void outputNoFmt(int msg_type,const char * text);
};

#endif //_KVI_HELPWINDOW_H_INCLUDED_
