#ifndef _KVI_DLGOPTIONS_H_INCLUDED_
#define _KVI_DLGOPTIONS_H_INCLUDED_

//
//   File : kvi_dlgoptions.h (/usr/build/NEW_kvirc/kvirc/src/kvirc/kvi_dlgoptions.h)
//   Last major modification : Tue May 4 1999 18:02:25 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_defines.h"

#include <qlistview.h>

#include <qlistbox.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qcheckbox.h>
#include <qwidget.h>
#include <qwidgetstack.h>
#include <qtableview.h>
#include <qpopupmenu.h>
#include <qfontmetrics.h>
#include <qcombobox.h>
#include <qlineedit.h>

class KviListView;

#define KVI_GENERAL_OPTIONS_WIDGET_ID_NONE 0
#define KVI_GENERAL_OPTIONS_WIDGET_ID_DEFAULTMESSAGES 1
#define KVI_GENERAL_OPTIONS_WIDGET_ID_CTCPMESSAGES 2
#define KVI_GENERAL_OPTIONS_WIDGET_ID_REDIRECTIONS 3
#define KVI_GENERAL_OPTIONS_WIDGET_ID_CTCPPROTECTION 4
#define KVI_GENERAL_OPTIONS_WIDGET_ID_CTCPMULTIMEDIA 5
#define KVI_GENERAL_OPTIONS_WIDGET_ID_VIEW 6
#define KVI_GENERAL_OPTIONS_WIDGET_ID_INPUT 7
#define KVI_GENERAL_OPTIONS_WIDGET_ID_LOGGING 8
#define KVI_GENERAL_OPTIONS_WIDGET_ID_DIRBROWSER 9
#define KVI_GENERAL_OPTIONS_WIDGET_ID_OUTPUT 10
#define KVI_GENERAL_OPTIONS_WIDGET_ID_MIMETYPES 11
#define KVI_GENERAL_OPTIONS_WIDGET_ID_PLUGINS 12
#define KVI_GENERAL_OPTIONS_WIDGET_ID_IRCMISC 13
#define KVI_GENERAL_OPTIONS_WIDGET_ID_INTERFACEMISC 14
#define KVI_GENERAL_OPTIONS_WIDGET_ID_DCCGENERAL 15
#define KVI_GENERAL_OPTIONS_WIDGET_ID_DCCCHAT 16
#define KVI_GENERAL_OPTIONS_WIDGET_ID_DCCSEND 17
#define KVI_GENERAL_OPTIONS_WIDGET_ID_DCCVOICE 18
#define KVI_GENERAL_OPTIONS_WIDGET_ID_SCRIPTCENTER 19
#define KVI_GENERAL_OPTIONS_WIDGET_ID_GUIMDI 20
#define KVI_GENERAL_OPTIONS_WIDGET_ID_GUIINPUT 21
#define KVI_GENERAL_OPTIONS_WIDGET_ID_GUILABELS 22
#define KVI_GENERAL_OPTIONS_WIDGET_ID_GUIHELP 23
#define KVI_GENERAL_OPTIONS_WIDGET_ID_GUILISTBOX 24
#define KVI_GENERAL_OPTIONS_WIDGET_ID_GUIOUTPUT 25
#define KVI_GENERAL_OPTIONS_WIDGET_ID_GUIMIRCCOLORS 26
#define KVI_GENERAL_OPTIONS_WIDGET_ID_GUIMESSAGES 27
#define KVI_GENERAL_OPTIONS_WIDGET_ID_GUISYSTRAY 28
#define KVI_GENERAL_OPTIONS_WIDGET_ID_GUIGLOBAL 29
#define KVI_GENERAL_OPTIONS_WIDGET_ID_CHARSETTRANSLATION 30

class KviGeneralOptionsWidget : public QFrame
{
	Q_OBJECT
public:
	KviGeneralOptionsWidget(QWidget * parent,int id);
	~KviGeneralOptionsWidget();
protected:
	int m_id;
public:
	virtual void commitChanges();
	void commitFileSelectors();
	void commitIpSelectors();
	void commitCharSelectors();
	void commitColorSelectors();
	void commitFontSelectors();
	void commitImageSelectors();
};

//====================== FrontWidget //

class KviGeneralOptionsFrontWidget : public KviGeneralOptionsWidget
{
	Q_OBJECT
public:
	KviGeneralOptionsFrontWidget(QWidget * parent);
	~KviGeneralOptionsFrontWidget();
};

//====================== DefaultMessages //

class KviGeneralOptionsDefaultMessagesWidget : public KviGeneralOptionsWidget
{
	Q_OBJECT
public:
	KviGeneralOptionsDefaultMessagesWidget(QWidget *parent);
	~KviGeneralOptionsDefaultMessagesWidget();
public:
	virtual void commitChanges();
};

//====================== MiscInterface //

class KviGeneralOptionsInterfaceMiscWidget : public KviGeneralOptionsWidget
{
	Q_OBJECT
public:
	KviGeneralOptionsInterfaceMiscWidget(QWidget *parent);
	~KviGeneralOptionsInterfaceMiscWidget();
public:
	virtual void commitChanges();
};

//====================== DccGeneral //

class KviGeneralOptionsDccGeneralWidget : public KviGeneralOptionsWidget
{
	Q_OBJECT
public:
	KviGeneralOptionsDccGeneralWidget(QWidget *parent);
	~KviGeneralOptionsDccGeneralWidget();
protected:
	QLineEdit * m_pIncomingDirEdit;
public:
	virtual void commitChanges();
protected slots:
	void chooseIncomingDir();
};

//====================== DccChat //

class KviGeneralOptionsDccChatWidget : public KviGeneralOptionsWidget
{
	Q_OBJECT
public:
	KviGeneralOptionsDccChatWidget(QWidget *parent);
	~KviGeneralOptionsDccChatWidget();
public:
	virtual void commitChanges();
};

//====================== DccSend //

class KviGeneralOptionsDccSendWidget : public KviGeneralOptionsWidget
{
	Q_OBJECT
public:
	KviGeneralOptionsDccSendWidget(QWidget *parent);
	~KviGeneralOptionsDccSendWidget();
public:
	virtual void commitChanges();
};

//====================== DccVoice //

class KviGeneralOptionsDccVoiceWidget : public KviGeneralOptionsWidget
{
	Q_OBJECT
public:
	KviGeneralOptionsDccVoiceWidget(QWidget *parent);
	~KviGeneralOptionsDccVoiceWidget();
public:
	virtual void commitChanges();
};

//====================== Plugins //

class KviGeneralOptionsPluginsWidget : public KviGeneralOptionsWidget
{
	Q_OBJECT
public:
	KviGeneralOptionsPluginsWidget(QWidget *parent);
	~KviGeneralOptionsPluginsWidget();
protected:

#ifdef COMPILE_PLUGIN_SUPPORT

	QListBox * m_pPluginBox;
	QLabel * m_pPluginModuleNameLabel;
	QLabel * m_pPluginDescriptionLabel;
	QLabel * m_pPluginAuthorLabel;
	QLabel * m_pPluginVersionLabel;
	QLabel * m_pPluginServiceNameLabel;
	QPushButton * m_pUnloadPlugin;
	QPushButton * m_pConfigurePlugin;
	QPushButton * m_pHelpOnPlugin;
	QCheckBox * m_pPluginAutoloadCheck;

#endif

public:
	virtual void commitChanges();

#ifdef COMPILE_PLUGIN_SUPPORT

	void fillPluginBox(unsigned int selectIdx = 0);

#endif

protected slots:
	// moc always wants the skeletons of the slots
	void pluginListItemSelected(const QString &str);
	void pluginAutoloadToggled(bool bActive);
	void pluginLoad();
	void pluginUnload();
	void pluginConfigure();
	void pluginHelp();
};

//====================== CharsetTranslation //

class KviGeneralOptionsCharsetTranslationWidget : public KviGeneralOptionsWidget
{
	Q_OBJECT
public:
	KviGeneralOptionsCharsetTranslationWidget(QWidget *parent);
	~KviGeneralOptionsCharsetTranslationWidget();
#ifdef COMPILE_NEED_CHARSET_TRANSLATION
protected:
	QLineEdit * m_pMapFileEdit;
	QPushButton * m_pBrowseBtn;
public:
	virtual void commitChanges();
#endif
protected slots:
	void chooseTranslationMap();
};

//====================== MimeTypes //

class KviGeneralOptionsMimeTypesWidget : public KviGeneralOptionsWidget
{
	Q_OBJECT
public:
	KviGeneralOptionsMimeTypesWidget(QWidget *parent);
	~KviGeneralOptionsMimeTypesWidget();
protected:
	KviListView * m_pMimeView;
public:
	virtual void commitChanges();
protected slots:
	void addNewMime();
	void deleteSelectedMimes();
};

//====================== DirBrowser //

class KviGeneralOptionsDirBrowserWidget : public KviGeneralOptionsWidget
{
	Q_OBJECT
public:
	KviGeneralOptionsDirBrowserWidget(QWidget *parent);
	~KviGeneralOptionsDirBrowserWidget();
public:
	virtual void commitChanges();
};

//====================== ScriptCenter //

class KviGeneralOptionsScriptCenterWidget : public KviGeneralOptionsWidget
{
	Q_OBJECT
public:
	KviGeneralOptionsScriptCenterWidget(QWidget *parent);
	~KviGeneralOptionsScriptCenterWidget();
public:
	virtual void commitChanges();
};

//====================== Output //

class KviGeneralOptionsOutputWidget : public KviGeneralOptionsWidget
{
	Q_OBJECT
public:
	KviGeneralOptionsOutputWidget(QWidget *parent);
	~KviGeneralOptionsOutputWidget();
public:
	virtual void commitChanges();
};

//====================== CtcpMessages //

class KviGeneralOptionsCtcpMessagesWidget : public KviGeneralOptionsWidget
{
	Q_OBJECT
public:
	KviGeneralOptionsCtcpMessagesWidget(QWidget *parent);
	~KviGeneralOptionsCtcpMessagesWidget();
public:
	virtual void commitChanges();
};

//====================== IrcMisc //

class KviGeneralOptionsIrcMiscWidget : public KviGeneralOptionsWidget
{
	Q_OBJECT
public:
	KviGeneralOptionsIrcMiscWidget(QWidget *parent);
	~KviGeneralOptionsIrcMiscWidget();
public:
	virtual void commitChanges();
};

//====================== CtcpProtection //

class KviGeneralOptionsCtcpProtectionWidget : public KviGeneralOptionsWidget
{
	Q_OBJECT
public:
	KviGeneralOptionsCtcpProtectionWidget(QWidget *parent);
	~KviGeneralOptionsCtcpProtectionWidget();
public:
	virtual void commitChanges();
};

//====================== CtcpMultimedia //

class KviGeneralOptionsCtcpMultimediaWidget : public KviGeneralOptionsWidget
{
	Q_OBJECT
public:
	KviGeneralOptionsCtcpMultimediaWidget(QWidget *parent);
	~KviGeneralOptionsCtcpMultimediaWidget();
public:
	virtual void commitChanges();
};

//====================== Redirections //

class KviGeneralOptionsRedirectionsWidget : public KviGeneralOptionsWidget
{
	Q_OBJECT
public:
	KviGeneralOptionsRedirectionsWidget(QWidget *parent);
	~KviGeneralOptionsRedirectionsWidget();
public:
	virtual void commitChanges();
};

//====================== View //

class KviGeneralOptionsViewWidget : public KviGeneralOptionsWidget
{
	Q_OBJECT
public:
	KviGeneralOptionsViewWidget(QWidget *parent);
	~KviGeneralOptionsViewWidget();
public:
	virtual void commitChanges();
protected:
	QComboBox *m_pBrowserCommandlineBox;
	QLineEdit *m_pBrowserCommandlineEdit;
protected slots:
	void fillBrowserCommandlineEdit(int index);
private:
	void fillBrowserCommandlineBox();
};

//====================== Input //

class KviGeneralOptionsInputWidget : public KviGeneralOptionsWidget
{
	Q_OBJECT
public:
	KviGeneralOptionsInputWidget(QWidget *parent);
	~KviGeneralOptionsInputWidget();
protected:
	KviListView * m_pStrSubView;
public:
	virtual void commitChanges();
public slots:
	void addNewString();
	void deleteSelectedStrings();
};

//====================== GuiMdi //

class KviNewImageSelector;

class KviGeneralOptionsGuiMdiWidget : public KviGeneralOptionsWidget
{
	Q_OBJECT
public:
	KviGeneralOptionsGuiMdiWidget(QWidget *parent);
	~KviGeneralOptionsGuiMdiWidget();
public:
	KviNewImageSelector * m_pMdiImageSelector;
public:
	virtual void commitChanges();
};

//====================== GuiMdi //

class KviGeneralOptionsGuiInputWidget : public KviGeneralOptionsWidget
{
	Q_OBJECT
public:
	KviGeneralOptionsGuiInputWidget(QWidget *parent);
	~KviGeneralOptionsGuiInputWidget();
public:
	KviNewImageSelector * m_pInputImageSelector;
public:
	virtual void commitChanges();
};

//====================== GuiLabels //

class KviGeneralOptionsGuiLabelsWidget : public KviGeneralOptionsWidget
{
	Q_OBJECT
public:
	KviGeneralOptionsGuiLabelsWidget(QWidget *parent);
	~KviGeneralOptionsGuiLabelsWidget();
public:
	KviNewImageSelector * m_pLabelsImageSelector;
public:
	virtual void commitChanges();
};

//====================== GuiListBox //

class KviGeneralOptionsGuiListBoxWidget : public KviGeneralOptionsWidget
{
	Q_OBJECT
public:
	KviGeneralOptionsGuiListBoxWidget(QWidget *parent);
	~KviGeneralOptionsGuiListBoxWidget();
public:
	KviNewImageSelector * m_pListBoxImageSelector;
public:
	virtual void commitChanges();
};

//====================== GuiSysTray //

class KviGeneralOptionsGuiSysTrayWidget : public KviGeneralOptionsWidget
{
	Q_OBJECT
public:
	KviGeneralOptionsGuiSysTrayWidget(QWidget *parent);
	~KviGeneralOptionsGuiSysTrayWidget();
public:
	virtual void commitChanges();
};

//====================== GuiOutput //

class KviGeneralOptionsGuiOutputWidget : public KviGeneralOptionsWidget
{
	Q_OBJECT
public:
	KviGeneralOptionsGuiOutputWidget(QWidget *parent);
	~KviGeneralOptionsGuiOutputWidget();
public:
	KviNewImageSelector * m_pOutputImageSelector;
public:
	virtual void commitChanges();
};

//====================== GuiMessages //

class KviMessageColorView : public QTableView
{
	Q_OBJECT
public:
	KviMessageColorView(QWidget * par);
	~KviMessageColorView();
protected:
	QPopupMenu * m_pPopup;
	QPopupMenu * m_pForePopup;
	QPopupMenu * m_pBackPopup;
	unsigned char m_clrBack[KVI_OUT_NUM_IMAGES + 2];
	QPixmap * m_pColorPixmap[16];
	int m_selectedRow;
	QFontMetrics * m_pFm;
	unsigned char m_clrFore[KVI_OUT_NUM_IMAGES + 2];
    virtual void paintCell(QPainter *p, int row, int col );
//	virtual void setupPainter(QPainter *p);
	virtual void resizeEvent(QResizeEvent *e);
	virtual void mousePressEvent(QMouseEvent *e);
public:
	void commit();
public slots:
	void forePopupActivated(int id);
	void backPopupActivated(int id);
	void save();
	void load();
};

class KviGeneralOptionsGuiMessagesWidget : public KviGeneralOptionsWidget
{
	Q_OBJECT
public:
	KviGeneralOptionsGuiMessagesWidget(QWidget *parent);
	~KviGeneralOptionsGuiMessagesWidget();
public:
	KviMessageColorView * m_pMessageColorView;
	virtual void commitChanges();
};

//====================== GuiHelp //

class KviGeneralOptionsGuiHelpWidget : public KviGeneralOptionsWidget
{
	Q_OBJECT
public:
	KviGeneralOptionsGuiHelpWidget(QWidget *parent);
	~KviGeneralOptionsGuiHelpWidget();
public:
	virtual void commitChanges();
};


//====================== GuiGlobal //

class KviGeneralOptionsGuiGlobalWidget : public KviGeneralOptionsWidget
{
	Q_OBJECT
public:
	KviGeneralOptionsGuiGlobalWidget(QWidget *parent);
	~KviGeneralOptionsGuiGlobalWidget();
public:
	virtual void commitChanges();
protected:
	QComboBox           *m_pGUIStyleBox;
private:
	void fillGuiStylesBox();

};

class KviNewColorSelector;

//====================== GuiHelp //

class KviGeneralOptionsGuiMircColorsWidget : public KviGeneralOptionsWidget
{
	Q_OBJECT
public:
	KviGeneralOptionsGuiMircColorsWidget(QWidget *parent);
	~KviGeneralOptionsGuiMircColorsWidget();
public:
	KviNewColorSelector * m_pMircColorSelector[16];
public:
	virtual void commitChanges();
protected slots:
	void resetToMircColors();
	void invertColors();
	void makeDarker();
	void makeLighter();
};



//====================== Logging //

class KviGeneralOptionsLoggingWidget : public KviGeneralOptionsWidget
{
	Q_OBJECT
public:
	KviGeneralOptionsLoggingWidget(QWidget *parent);
	~KviGeneralOptionsLoggingWidget();
public:
	QListView * m_pLogMsgTypesView;
public:
	virtual void commitChanges();
protected slots:
	void logMsgTypeViewItemDoubleClicked(QListViewItem *it);
};

//======================//
// 
// MAIN DIALOG
//

class KviGeneralOptionsListViewItem : public QListViewItem
{
public:
	KviGeneralOptionsListViewItem(QListView * parent,const QPixmap& pm,const char *category);
	KviGeneralOptionsListViewItem(QListViewItem * parent,const QPixmap &pm,const char *category,int id);
	~KviGeneralOptionsListViewItem();
public:
	KviGeneralOptionsWidget * m_pOptionsWidget;
	int                       m_id;
};

class KviGeneralOptionsDialog : public QWidget
{
	Q_OBJECT
public:
	KviGeneralOptionsDialog(QWidget * parent);
	~KviGeneralOptionsDialog();
protected:
	QLabel       * m_pCategoryLabel;
	QListView    * m_pListView;
	QWidgetStack * m_pWidgetStack;
protected:
	virtual void closeEvent(QCloseEvent *e);
	virtual void showEvent(QShowEvent *e);
	void recursiveCommit(KviGeneralOptionsListViewItem *it);
signals:
	void finished(bool bCommitChanges);
protected slots:
	void okClicked();
	void cancelClicked();
	void listViewItemSelectionChanged (QListViewItem *it);
};

#endif //!_KVI_DLGOPTIONS_H_INCLUDED_
