#ifndef _KVI_DIRBROWSER_H_INCLUDED_
#define _KVI_DIRBROWSER_H_INCLUDED_

//
//   File : kvi_dirbrowser.h (/usr/build/NEW_kvirc/kvirc/src/kvirc/kvi_dirbrowser.h)
//   Last major modification : Sun Apr 25 1999 13:57:12 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_string.h"
#include "kvi_window.h"
#include "kvi_thread.h"

#include <qtoolbar.h>
#include <qiconview.h>
#include <qtoolbutton.h>
#include <qlineedit.h>
#include <qevent.h>
#include <qvaluelist.h>
#include <qpopupmenu.h>
//#include <qfont.h>

typedef struct KviDirBrowserEntry
{
	KviStr szAbsFilePath;
	KviStr szFileName;
	KviStr szDirPath;
	unsigned int uSize;
	KviStr szMimeName;
	KviStr szCommandline;
	KviStr szIconPath;
	KviStr szKey;
	bool   bIsDirectory;
	bool   bIsReadable;
	bool   bIsFile;
	bool   bIsSymLink;
	bool   bIsSocket;
	bool   bIsDevice;
};

class KviDirectoryView;

class KviDirectoryViewItem : public QIconViewItem
{
public:
	KviDirectoryViewItem(KviDirectoryView * view,KviDirBrowserEntry *e);
	~KviDirectoryViewItem();	
public:
	KviDirectoryView * m_view;
	KviDirBrowserEntry * m_data;
//public slots:
//	void itemRenamed(const QString & text);
};

class KviDirectoryView : public QIconView
{
	Q_OBJECT
public:
	KviDirectoryView(QWidget * parent,KviFrame * lpFrm);
	~KviDirectoryView();
public:
	KviStr m_szDirPath;
//	QFont  *m_pItalicFont;
	KviFrame * m_pFrm;
protected:
	QPopupMenu * m_pContextPopup;
protected:
	virtual QDragObject * dragObject();
	void applyOptionsInternal();
public:
	void applyOptions();
protected slots:
	void itemDropped(QDropEvent *e,const QValueList<QIconDragItem> & lst);
	void emitNeedUpdate();
	void showContextMenu(QIconViewItem * i,const QPoint &pos);
	void trashSelectedFiles();
	void openWithEditorSelectedFiles();
	void dirItemRenamed(QIconViewItem *i,const QString &text);
signals:
	void needUpdate();
};

typedef struct KviDirBrowserJob 
{
	KviStr szDirPath;
	QWidget * parent;
	bool bShowHidden;
	bool bGroupByExtension;
	bool bSortBySize;
	bool bCaseInsensitive;
	QList<KviDirBrowserEntry> * entries;
//	pthread_mutex_t * pJobMutex;
};

class KviDirectoryBrowserWidget : public QWidget
{
	Q_OBJECT
public:		// Consruction & Destruction
	KviDirectoryBrowserWidget(QWidget * parent,KviFrame *lpFrm,const char *dirname);
	~KviDirectoryBrowserWidget();
public:		// Fields
	KviFrame         * m_pFrm;
	KviDirectoryView * m_pDirView;
	QToolBar         * m_pToolBar;
	QToolButton      * m_pCdUp;
	QToolButton      * m_pShowBookmarks;
	QLineEdit        * m_pDirPathEdit;
	KviStr             m_szDirPath;
	KviDirBrowserJob * m_pJob;
	pthread_t          m_childThread;
	QPopupMenu       * m_pBookmarksPopup;
public:		// Methods
	bool loadDirectory(const char *dirname);
	void stop();
//	virtual QSize sizeHint();
	void applyOptions();
protected:	// Protected methods
	virtual void resizeEvent(QResizeEvent *e);
	virtual bool event(QEvent *e);
private:
	bool setDirPathAndEnsureReadable(const char *dirname);
	bool beginReadCurrentDirectory();
	bool isDirReadable(const char *dirname);
public slots:
	void cdUp();
	void cdReload();
	void cdHome();
	void cdKviHome();
	void showBookmarksPopup();
	void bookmarkSelected(int id);
protected slots:
	void itemDoubleClicked(QIconViewItem * it);
	void selectionChanged();
	void returnPressed();
};

class KviDirectoryBrowser : public KviWindow
{
	Q_OBJECT
public:		// Consruction & Destruction
	KviDirectoryBrowser(KviFrame *lpFrm,const char *dirname);
	~KviDirectoryBrowser();
public:		// Fields
	KviDirectoryBrowserWidget * m_pBrowser;
public:		// Methods
	bool loadDirectory(const char *dirname){ return m_pBrowser->loadDirectory(dirname); };
	void stop(){ m_pBrowser->stop(); };
protected:	// Protected methods
	virtual QPixmap * myIconPtr();
	virtual void resizeEvent(QResizeEvent *);
	virtual void applyOptions();
	virtual void setProperties(KviWindowProperty *p);
	virtual void saveProperties();
};

#endif //!_KVI_DIRBROWSER_H_INCLUDED_
