#ifndef _KVI_DCC_CHAT_H_INCLUDED_
#define _KVI_DCC_CHAT_H_INCLUDED_

//
//   File : kvi_dcc_chat.h (/usr/build/NEW_kvirc/kvirc/src/kvirc/kvi_dcc_chat.h)
//   Last major modification : Thu Feb 11 1999 20:06:34 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_window.h"
#include "kvi_thread.h"
#include "kvi_string.h"

#include <qqueue.h>

class KviDccChat;
class KviIrcView;

typedef struct KviDccChatStruct
{
	KviStr nick;
	KviStr username;
	KviStr host;
	KviStr szAddress;
	unsigned long uAddress; //an internet address in network byte order
	unsigned short uPort; // a port in host byte order
	KviDccChat *dccChatParent;
	QQueue<KviStr> * outQueue;
	pthread_mutex_t outMutex;
	KviStr szPartialBuffer;
	KviStr tmpBuffer;
	unsigned short int uPortToListenOn;
};

class KviDccChat : public KviWindow
{
	Q_OBJECT
public:		// Consruction & Destruction
	KviDccChat(KviFrame *lpFrm,const char *name);
	~KviDccChat();
public:		// Fields
	pthread_t m_thread;
	bool m_bThreadRunning;
	KviDccChatStruct * m_pDccChatStruct;
	KviStr m_szRemoteNick;
	KviStr m_szRemoteMask;
	KviStr m_szLocalNick;
	KviStr m_szLocalMask;
	KviStr m_szRemoteInfo;
public:		// Methods
	void acceptDccRequest(const char *nick,const char *username,const char *host,unsigned long uAddress,unsigned short uPort);
	void requestDcc(const char *nick,const char *username,const char *host);
	bool sendData(const char *buffer);
protected:	// Protected methods
	virtual QPixmap * myIconPtr();
	virtual void resizeEvent(QResizeEvent *);
	virtual void applyOptions();
	virtual bool event(QEvent *e);
	virtual void closeEvent(QCloseEvent *e);
public slots:
	void viewRightClicked(KviIrcView *);
	void viewPopupClicked(const KviStr &dataBuffer);
};

#endif //_KVI_DCC_CHAT_H_INCLUDED_
