#ifndef _KVI_ALIAS_H_INCLUDED_
#define _KVI_ALIAS_H_INCLUDED_

//
//   File : kvi_alias.h (/usr/build/NEW_kvirc/kvirc/src/kvirc/kvi_alias.h)
//   Last major modification : Sat Mar 6 1999 20:16:05 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_string.h"
#include "kvi_fileutils.h"

#include <qlist.h>

typedef struct KviAlias
{
	KviStr szName;
	KviStr szBuffer;
	bool bLocked; //Set to 1 while the alias is executed , so /ALIAS will not allow modifying it
};

class KviAliasManager
{
	friend class KviDlgScript;
	friend class KviAliasEditor;
public:
	KviAliasManager();
	~KviAliasManager();
protected:
	QList<KviAlias> * m_pAliasList;
public:
	void clearAll();
	int count(){ return  m_pAliasList->count(); };
//	void setAliasList(KviAliasManager *copyFrom);
	KviAlias * findAlias(const char *name);
	bool addAlias(KviAlias *s);
	void removeAlias(KviAlias *s);
	bool removeAlias(const char *name);
	bool load(const char *filename,KviStr &error);
	bool save(const char *filename);
	QList<KviAlias> * aliasList(){ return m_pAliasList; };
};

#endif //!_KVI_ALIAS_H_INCLUDED_
