#ifndef _KVI_DEBUG_H_INCLUDED_
#define _KVI_DEBUG_H_INCLUDED_

//
//   File : kvi_debug.h (/usr/build/NEW_kvirc/kvirc/src/common/kvi_debug.h)
//   Last major modification : Fri Mar 19 1999 03:10:39 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#undef __range_valid
#undef __range_invalid
#undef __debug
#undef __debug_1arg
#undef __debug_2arg
#undef __enter
#undef __leave

//The main switch is in this file
#include "kvi_settings.h"

#include <qglobal.h> //always include it for debug()

#ifndef COMPILE_DEBUG_SESSION
	#undef _KVI_DEBUG_CHECK_RANGE_
	#undef _KVI_DEBUG_CLASS_NAME_
#endif

#ifdef _KVI_DEBUG_CHECK_RANGE_
	#define __range_valid(_expr) if(!(_expr))debug("RANGE ASSERT : \"%s\" is false in %s (%d)",#_expr,__FILE__,__LINE__)
	#define __range_invalid(_expr) if(_expr)debug("RANGE ASSERT : \"%s\" is true in %s (%d)",#_expr,__FILE__,__LINE__)
#else
	#define __range_valid(_expr)
	#define __range_invalid(_expr)
#endif //!_KVI_DEBUG_RANGE_

#ifdef _KVI_DEBUG_CLASS_NAME_
	#define __debug(_text) debug("%s::%s",_KVI_DEBUG_CLASS_NAME_,_text)
	#define __debug_1arg(__a1,__a2) debug(__a1,__a2)
	#define __debug_2arg(__a1,__a2,__a3) debug(__a1,__a2,__a3)
	#define __enter(_text) debug("---> %s::%s",_KVI_DEBUG_CLASS_NAME_,_text)
	#define __leave(_text) debug("<--- %s::%s",_KVI_DEBUG_CLASS_NAME_,_text)

#else
	#define __debug(_text)
	#define __debug_1arg(__a1,__a2)
	#define __debug_2arg(__a1,__a2,__a3)
	#define __enter(_text)
	#define __leave(_text)
#endif

#endif //_KVI_DEBUG_H_INCLUDED_
