/***************************************************************************
 *   Copyright (C) 2005-2006 by Raul Fernandes                             *
 *   rgfbr@yahoo.com.br                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef DZIP_H
#define DZIP_H

#include <qstring.h>
#include <qvaluelist.h>

class QFile;

/**
@author Raul Fernandes
*/
class DictZip{
public:
    DictZip( const QString & );

    ~DictZip();

    QString filename() { return m_filename; };
    QString search( const QString & );
    int size();
    bool isOk(){ return m_isOk; };

protected:
    unsigned long mtime()  { return m_mtime; };
    bool extraField() { return m_extraField; };
    bool hasName() { return m_hasName; };
    void readExtraField();
    void readFileName();
    void readComment();
    QCString Inflate( const QByteArray & );
    unsigned long b64_decode( const char * );

    bool m_isOk;

    bool isCompressed;
    char FLAGS;
    QFile *file;
    QFile *idxFile;
    bool m_extraField;
    bool m_hasName;
    bool FTEXT; // bit 0 - is text
    bool FHCRC; // bit 1 - has CRC16
    bool FCOMMENT; // bit 3 - has commentary
    unsigned long m_mtime;
    unsigned long XLEN;
    char SI1, SI2;
    unsigned long LEN, VER, CHLEN, CHCNT;
    QValueList<unsigned long> offsets;
    QString m_comment;
    QString m_filename;
    char *crc16[2];
    unsigned long offset;

    struct entry{
    QString headword;
    unsigned long position;
    unsigned long size;
    };

#ifndef NOPTIMIZE
    typedef QValueList<entry> Dictionary;
    Dictionary dic;
#endif
};

#endif
