/***************************************************************************
 *   Copyright (C) 2004-2006 by Raul Fernandes                             *
 *   rgfbr@yahoo.com.br                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "babylonplugin.h"
#include <kgenericfactory.h>

#include <qvbox.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qfile.h>

#include <kurl.h>

#ifndef NDEBUG

#include <kdebug.h>

#endif


K_EXPORT_COMPONENT_FACTORY( ktranslator_babylon,
                            KGenericFactory<BabylonPlugin>( "ktranslator_babylon" ) )

BabylonPlugin::BabylonPlugin( QObject *parent, const char*, const QStringList &args )
            : KTranslator::DictionaryPlugin(parent, "Babylon" )
{
  KLocale::setMainCatalogue("ktranslator");
  // opens the Babylon dictionary
  KURL url( args[0] );
  name = args[1];
  babDic = 0;
  babDic = new Babylon;
  babDic->setPath( url.directory().ascii() );
  if( !babDic->open( url.fileName().ascii() ) )
  {
    setOk( false );
    return;
  }

  setOk( true );
  setEnabled( true );
  m_tooltip = i18n( "Babylon Dictionary" );
}


BabylonPlugin::~BabylonPlugin()
{
  if( babDic ) delete babDic;
  babDic = 0;
}


QString BabylonPlugin::search( const QString &word )
{

  #ifndef NDEBUG

  kdDebug() << "BabylonPlugin search()" << endl;

  #endif

  QString result;
  QString babylonOutput;

    // search in Babylon dictionary
    Babylon::ContainerType translations;
    result.append( QString( "<dicName>%1</dicName>" ).arg( name ) );

    // try a translation and test to check for errors
    if ( ! babDic->translate( word.ascii(), translations ) )
    {
      // error
      result += "<font color=#000000>" + i18n( "Word not found<br>Error in dictionary" ) + "</font>";
      result += babDic->getError().c_str();
    }else if ( translations.empty() )
    {
      // none translation
      result += "<font color=#000000>" + i18n( "Word not found" ) + "</font>";
    }else
    {
      // iterate through results list
      Babylon::ContainerType::iterator end( translations.end() );
      for ( Babylon::ContainerType::iterator it = translations.begin() ; it != end ; ++it )
      {
        result += "<headword>";
        result += it->word.c_str();
        result += "</headword>";
        babylonOutput = it->attrib.c_str();

        QString tt = babylonOutput.mid( 2, 9 );
        if ( tt == "000000000" )
        {
          // noun without plural
          result += "<pos>";
          result += "s";
          result += "</pos>";
        } else if ( tt == "100000000" )
        {
          // noun ending in f
          // plural with -f +ves
          result += "<inflection>";
          result += "plural: ";
          result += it->word.c_str();
          result = result.left( result.length() - 1 );
          result += "ves";
          result += "</inflection><pos>";
          result += "s";
          result += "</pos>";
        } else if ( tt == "200000000" )
        {
          // noun ending in fe
          // plural with -fe +ves
          result += "<inflection>";
          result += "plural: ";
          result += it->word.c_str();
          result = result.left( result.length() - 2 );
          result += "ves";
          result += "</inflection><pos>";
          result += "s";
          result += "</pos>";
        } else if ( tt == "400000000" )
        {
          // noun
          // plural with +e
          result += "<inflection>";
          result += "plural: ";
          result += it->word.c_str();
          result += "e";
          result += "</inflection><pos>";
          result += "s";
          result += "</pos>";
        } else if ( tt == "800000000" )
        {
          // noun ending in is
          // plural with -is +es
          result += "<inflection>";
          result += "plural: ";
          result += it->word.c_str();
          result = result.left( result.length() - 2 );
          result += "es";
          result += "</inflection><pos>";
          result += "s";
          result += "</pos>";
        } else if ( tt == "010000000" )
        {
          // noun
          // irregular plural
          result += "<pos>";
          result += "s";
          result += "</pos>";
        } else if ( tt == "020000000" )
        {
          // noun
          // plural with +s
          result += "<inflection>";
          result += "plural: ";
          result += it->word.c_str();
          result += "s";
          result += "</inflection><pos>";
          result += "s";
          result += "</pos>";
        } else if ( tt == "040000000" )
        {
          // noun ending in ss, ch, x
          // plural with +es
          result += "<inflection>";
          result += "plural: ";
          result += it->word.c_str();
          result += "es";
          result += "</inflection><pos>";
          result += "s";
          result += "</pos>";
        } else if ( tt == "080000000" )
        {
          // noun ending in y
          // plural with -y +ies
          result += "<inflection>";
          result += "plural: ";
          result += it->word.c_str();
          result = result.left( result.length() - 1 );
          result += "ies";
          result += "</inflection><pos>";
          result += "s";
          result += "</pos>";
        } else if ( tt == "001000000" )
        {
          // noun ending in us
          // plural with -us +i
          result += "<inflection>";
          result += "plural: ";
          result += it->word.c_str();
          result = result.left( result.length() - 2 );
          result += "i";
          result += "</inflection><pos>";
          result += "s";
          result += "</pos>";
        } else if ( tt == "008000000" )
        {
          // noun - biographical name
          // no plural
          result += "<pos>";
          result += "s";
          result += "</pos>";
        } else if ( tt == "000100000" )
        {
          // noun ending in is
          // plural with -s +des
          result += "<inflection>";
          result += "plural: ";
          result += it->word.c_str();
          result = result.left( result.length() - 1 );
          result += "des";
          result += "</inflection><pos>";
          result += "s";
          result += "</pos>";
        } else if ( tt == "000200000" )
        {
          // noun ending in um
          // plural with -um +a
          result += "<inflection>";
          result += "plural: ";
          result += it->word.c_str();
          result = result.left( result.length() - 2 );
          result += "a";
          result += "</inflection><pos>";
          result += "s";
          result += "</pos>";
        } else if ( tt == "000400000" )
        {
          // noun ending in an
          // plural with -an +en
          result += "<inflection>";
          result += "plural: ";
          result += it->word.c_str();
          result = result.left( result.length() - 2 );
          result += "en";
          result += "</inflection><pos>";
          result += "s";
          result += "</pos>";
        } else if ( tt == "000800000" )
        {
          // noun ending in on
          // plural with -on +a
          result += "<inflection>";
          result += "plural: ";
          result += it->word.c_str();
          result = result.left( result.length() - 2 );
          result += "a";
          result += "</inflection><pos>";
          result += "s";
          result += "</pos>";
        } else if ( tt == "000010000" )
        {
          // adjective
          result += "<inflection>";
          result += "comparative: ";
          result += it->word.c_str();
          result = result.left( result.length() - 1 );
          result += "ier<br>";
          result += "superlative: ";
          result += it->word.c_str();
          result = result.left( result.length() - 1 );
          result += "iest";
          result += "</inflection>";
          result += "<pos>";
          result += "adj";
          result += "</pos>";
        } else if ( tt == "000001000" )
        {
          // adjective
          result += "<pos>";
          result += "adj";
          result += "</pos>";
        } else if ( tt == "000002000" )
        {
          // adjective
          result += "<inflection>";
          result += "comparative: ";
          result += it->word.c_str();
          result += "er<br>";
          result += "superlative: ";
          result += it->word.c_str();
          result += "est";
          result += "</inflection>";
          result += "<pos>";
          result += "adj";
          result += "</pos>";
        } else if ( tt == "000004000" )
        {
          // adjective
          result += "<inflection>";
          result += "comparative: ";
          result += it->word.c_str();
          result += result.right( 1 );
          result += "er<br>";
          result += "superlative: ";
          result += it->word.c_str();
          result += result.right( 1 );
          result += "est";
          result += "</inflection>";
          result += "<pos>";
          result += "adj";
          result += "</pos>";
        } else if ( tt == "000008000" )
        {
          // adjective
          result += "<inflection>";
          result += "comparative: ";
          result += it->word.c_str();
          result += "r<br>";
          result += "superlative: ";
          result += it->word.c_str();
          result += "st";
          result += "</inflection>";
          result += "<pos>";
          result += "adj";
          result += "</pos>";
        } else if ( tt == "010000800" )
        {
          // pronoum
          result += "<pos>";
          result += "pron";
          result += "</pos>";
        } else if ( tt == "020000800" )
        {
          // preposition
          result += "<pos>";
          result += "prep";
          result += "</pos>";
        } else if ( tt == "040000800" )
        {
          // conjunction
          result += "<pos>";
          result += "conj";
          result += "</pos>";
        } else if ( tt == "080000800" )
        {
          // interjection
          result += "<pos>";
          result += "inter";
          result += "</pos>";
        } else if ( tt == "000000100" )
        {
          // adverb
          result += "<pos>";
          result += "adv";
          result += "</pos>";
        } else if ( tt == "000020000" )
        {
          // irregular verb
          result += "<pos>";
          result += "v";
          result += "</pos>";
        } else if ( tt == "000040000" )
        {
          // regular verb ( 3p +s; past +ed; gerund +ing)
          result += "<inflection>";
          result += "3rd person: ";
          result += it->word.c_str();
          result += "s<br>";
          result += "past simple: ";
          result += it->word.c_str();
          result += "ed<br>";
          result += "gerund: ";
          result += it->word.c_str();
          result += "ing";
          result += "</inflection><pos>";
          result += "v";
          result += "</pos>";
        } else if ( tt == "000080000" )
        {
          // regular verb ending in ss, x ( 3p +es; past +ed; gerund +ing)
          result += "<inflection>";
          result += "3rd person: ";
          result += it->word.c_str();
          result += "es<br>";
          result += "past simple: ";
          result += it->word.c_str();
          result += "ed<br>";
          result += "gerund: ";
          result += it->word.c_str();
          result += "ing";
          result += "</inflection><pos>";
          result += "v";
          result += "</pos>";
        } else if ( tt == "000000010" )
        {
          // regular verb ending in y ( 3p -y +ies; past -y +ied; gerund +ing)
          result += "<inflection>";
          result += "3rd person: ";
          result += it->word.c_str();
          result = result.left( result.length() - 1 );
          result += "ies<br>";
          result += "past simple: ";
          result += it->word.c_str();
          result += result.left( result.length() - 1 );
          result += "ied<br>";
          result += "gerund: ";
          result += it->word.c_str();
          result += "ing";
          result += "</inflection><pos>";
          result += "v";
          result += "</pos>";
        } else if ( tt == "000000020" )
        {
          // regular verb ending in consoante ( 3p +s; past +1ed; gerund +1ing)
          result += "<inflection>";
          result += "3rd person: ";
          result += it->word.c_str();
          result += "es<br>";
          result += "past simple: ";
          result += it->word.c_str();
          result += result.right( 1 );
          result += "ed<br>";
          result += "gerund: ";
          result += it->word.c_str();
          result += result.right( 1 );
          result += "ing";
          result += "</inflection><pos>";
          result += "v";
          result += "</pos>";
        } else if ( tt == "000000040" )
        {
          // regular verb ending in e ( 3p +s; past +d; gerund -1 +ing)
          result += "<inflection>";
          result += "3rd person: ";
          result += it->word.c_str();
          result += "s<br>";
          result += "past simple: ";
          result += it->word.c_str();
          result += "d<br>";
          result += "gerund: ";
          result += it->word.c_str();
          result = result.left( result.length() - 1 );
          result += "ing";
          result += "</inflection><pos>";
          result += "v";
          result += "</pos>";
        }// else result += babylonOutput;

        babylonOutput = it->definition.c_str();
        babylonOutput.replace( ";", "<br>" );
        result += "<definition>" + babylonOutput + "</definition>";
      }
    }
  return result;
}


QWidget *BabylonPlugin::confPage()
{
  return new QLabel( "This plugin has no configurations", 0 );
}


void BabylonPlugin::applyConf( QWidget * )
{
  return;
}
