/***************************************************************************
                          toolsoptionsdialog.cpp  -  description
                             -------------------
    begin                : Wed Jun 6 2001
    copyright            : (C) 2001 by Brachet Pascal
    email                : pascal.brachet@free.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "toolsoptionsdialog.h"


#include <qlayout.h>
#include <klocale.h>


toolsoptionsdialog::toolsoptionsdialog( QWidget* parent,  const char* name)
    :KDialogBase( parent, 0L, true, i18n( "Configure Tools" ), Ok | Default | Cancel, Ok )
{
  QWidget *page = new QWidget(this);
  setMainWidget(page);

  QGridLayout *gbox = new QGridLayout( page, 9, 2, spacingHint() );
  gbox->addRowSpacing( 0, fontMetrics().lineSpacing() );

    TextLabel3 = new QLabel( page, "TextLabel3" );
    TextLabel3->setText( i18n( "LaTex Command :" ) );
    LineEdit3 = new QLineEdit( page, "LineEdit3" );
    LineEdit3->setFocus();

    TextLabel4 = new QLabel( page, "TextLabel4" );
    TextLabel4->setText( i18n( "Dvi viewer (X mode) :" ) );
    LineEdit4 = new QLineEdit( page, "LineEdit4" );

    TextLabel5 = new QLabel( page, "TextLabel5" );
    TextLabel5->setText( i18n( "Dvips command :" ) );
    LineEdit5 = new QLineEdit( page, "LineEdit5" );

    TextLabel6 = new QLabel( page, "TextLabel6" );
    TextLabel6->setText( i18n( "PS viewer (X mode) :" ) );
    LineEdit6 = new QLineEdit( page, "LineEdit6" );

    TextLabel7 = new QLabel( page, "TextLabel7" );
    TextLabel7->setText( i18n( "Ps2pdf command :" ) );
    LineEdit7 = new QLineEdit( page, "LineEdit7" );

    TextLabel8 = new QLabel( page, "TextLabel8" );
    TextLabel8->setText( i18n( "Makeindex command :" ) );
    LineEdit8 = new QLineEdit( page, "LineEdit8" );

    TextLabel9 = new QLabel( page, "TextLabel9" );
    TextLabel9->setText( i18n( "Bibtex command :" ) );
    LineEdit9 = new QLineEdit( page, "LineEdit9" );

    TextLabel10 = new QLabel( page, "TextLabel10" );
    TextLabel10->setText( i18n( "Pdflatex command :" ) );
    LineEdit10 = new QLineEdit( page, "LineEdit10" );

    TextLabel11 = new QLabel( page, "TextLabel11" );
    TextLabel11->setText( i18n( "Pdf viewer :" ) );
    LineEdit11 = new QLineEdit( page, "LineEdit11" );

  gbox->addWidget(TextLabel3 , 0, 0 );
  gbox->addWidget(LineEdit3 , 0, 1 );
  gbox->addWidget(TextLabel4 , 1, 0 );
  gbox->addWidget(LineEdit4 , 1, 1 );
  gbox->addWidget(TextLabel5 , 2, 0 );
  gbox->addWidget(LineEdit5 , 2, 1 );
  gbox->addWidget(TextLabel6 , 3, 0 );
  gbox->addWidget(LineEdit6 , 3, 1 );
  gbox->addWidget(TextLabel7 , 4, 0 );
  gbox->addWidget(LineEdit7 , 4, 1 );
  gbox->addWidget(TextLabel8 , 5, 0 );
  gbox->addWidget(LineEdit8 , 5, 1 );
  gbox->addWidget(TextLabel9 , 6, 0 );
  gbox->addWidget(LineEdit9 , 6, 1 );
  gbox->addWidget(TextLabel10 , 7, 0 );
  gbox->addWidget(LineEdit10 , 7, 1 );
  gbox->addWidget(TextLabel11 , 8, 0 );
  gbox->addWidget(LineEdit11 , 8, 1 );
  resize(420,320);

}


toolsoptionsdialog::~toolsoptionsdialog()
{

}

void  toolsoptionsdialog::slotDefault()
{
LineEdit3->setText("latex -interaction=nonstopmode $texname");
LineEdit4->setText("xdvi $dviname");
LineEdit5->setText("dvips -o $psname $dviname");
LineEdit6->setText("gv $psname");
LineEdit7->setText("ps2pdf $psname");
LineEdit8->setText("makeindex $idxname");
LineEdit9->setText("bibtex $bibname");
LineEdit10->setText("pdflatex -interaction=nonstopmode $texname");
LineEdit11->setText("acroread $pdfname");
}
