/***************************************************************************
                          structviewdialog.cpp  -  description
                             -------------------
    begin                : Sun Jun 3 2001
    copyright            : (C) 2001 by Brachet Pascal
    email                : pascal.brachet@free.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "structviewdialog.h"

#include <qlayout.h>
#include <klocale.h>

structviewdialog::structviewdialog( QWidget* parent,  const char* name)
    : KDialogBase( parent, 0L, true, i18n( "Define Structure View" ), Ok | Default | Cancel, Ok )
{

  QWidget *page = new QWidget( this );
  setMainWidget( page );

  QGridLayout *gbox = new QGridLayout( page, 7, 2, spacingHint() );
  gbox->addRowSpacing( 0, fontMetrics().lineSpacing() );


  TextLabel6 = new QLabel( page, "TextLabel6" );
  TextLabel6->setText( i18n( "Structure View Items (except include and input) :" ) );
  TextLabel6->setAlignment( int( QLabel::AlignCenter ) );
  gbox->addMultiCellWidget(TextLabel6,0,0,0,1,0);


  TextLabel1 = new QLabel( page, "TextLabel1" );
  TextLabel1->setText( i18n( "Level 1" ) );
  TextLabel2 = new QLabel( page, "TextLabel2" );
  TextLabel2->setText( i18n( "Level 2" ) );
  TextLabel3 = new QLabel( page, "TextLabel3" );
  TextLabel3->setText( i18n( "Level 3" ) );
  TextLabel4 = new QLabel( page, "TextLabel4" );
  TextLabel4->setText( i18n( "Level 4" ) );
  TextLabel5 = new QLabel( page, "TextLabel5" );
  TextLabel5->setText( i18n( "Level 5" ) );

  LineEdit1 = new QLineEdit( page, "LineEdit1" );
  LineEdit1->setFocus();
  LineEdit2 = new QLineEdit( page, "LineEdit2" );
  LineEdit3 = new QLineEdit( page, "LineEdit3" );
  LineEdit4 = new QLineEdit( page, "LineEdit4" );
  LineEdit5 = new QLineEdit( page, "LineEdit5" );

  gbox->addWidget(TextLabel1 , 1, 0 );
  gbox->addWidget(LineEdit1 , 1, 1 );
  gbox->addWidget(TextLabel2 , 2, 0 );
  gbox->addWidget(LineEdit2 , 2, 1 );
  gbox->addWidget(TextLabel3 , 3, 0 );
  gbox->addWidget(LineEdit3 , 3, 1 );
  gbox->addWidget(TextLabel4 , 4, 0 );
  gbox->addWidget(LineEdit4 , 4, 1 );
  gbox->addWidget(TextLabel5 , 5, 0 );
  gbox->addWidget(LineEdit5 , 5, 1 );



  TextLabel8 = new QLabel( page, "TextLabel8" );
  TextLabel8->setText( i18n( "( Enter the items without any '\\' character )" ) );
  TextLabel8->setAlignment( int( QLabel::AlignCenter ) );
  gbox->addMultiCellWidget(TextLabel8,6,6,0,1,0);
  resize(350,240);

}


structviewdialog::~structviewdialog()
{
}

void  structviewdialog::slotDefault()
{
LineEdit1->setText("part");
LineEdit2->setText("chapter");
LineEdit3->setText("section");
LineEdit4->setText("subsection");
LineEdit5->setText("subsubsection");
}
