// part of KSUDOKU - by Francesco Rossi <redsh@email.it> 2005

#ifndef _KSUDOKUVIEW_H_
#define _KSUDOKUVIEW_H_

#include <qwidget.h>
#include <kparts/part.h>
#include <qdatetime.h>
#include <ksudokuiface.h>
#include "sudoku_solver.h"
#include "qsudokubutton.h"
 

class QPainter;
class KURL;
class QSudokuButton;

struct btnData
{
	bool given[256];
	char  value[256];
};
/**
 * This is the main view class for ksudoku.  Most of the non-menu,
 * non-toolbar, and non-statusbar (e.g., non frame) GUI code should go
 * here.
 *
 * This ksudoku uses an HTML component as an example.
 *
 * @short Main view
 * @author Francesco Rossi <redsh@email.it>
 * @version 0.3
 */
 


class ksudokuView : public QWidget, public ksudokuIface
{
    Q_OBJECT
public:
	/**
	 * Default constructor
	 */
    ksudokuView(QWidget *parent);

	/**
	 * Destructor
	 */
    virtual ~ksudokuView();

    /**
     * Random 'get' function
     */
    QString currentURL();

    /**
     * Random 'set' function accessed by DCOP
     */
    virtual void openURL(QString url);

    /**
     * Random 'set' function
     */
    virtual void openURL(const KURL& url);

    /**
     * Print this view to any medium -- paper or not
     */
    void print(QPainter *, int height, int width);

signals:
    /**
     * Use this signal to change the content of the statusbar
     */
    void signalChangeStatusbar(const QString& text);

    /**
     * Use this signal to change the content of the caption
     */
    void signalChangeCaption(const QString& text);
	void changedSelectedNum();
public:
	int isWaitingForNumber;
	//bool guidedMode;
	bool showTracker;
	bool mouseOnlySuperscript;
	void setup(int order, int difficulty, int s, bool dub);

	void push();
	void pop();

private slots:



	void slotHello(int x, int y);
	void btn_enter(int x, int y);
	void btn_leave(int x, int y);
	
	void slotRight(int x, int y);

    void slotOnURL(const QString& url);
    void slotSetTitle(const QString& title);

	void beginHighlight(int val);
	void finishHighlight();
public:

	void createbuttons(int ord = 9);
	int genPuzzle(int difficulty, int s, bool dub=false);
protected:
	void resizeEvent(QResizeEvent *);
	void paintEvent(QPaintEvent *);


	
public:
	int order;
	int difficulty;
	QSudokuButton **btns;
	int current_selected_number;
	bool puzzle_mark_wrong;
	//int remaining;
	

	int highlighted;
	skPuzzle* puzzle;
	skPuzzle* completed_puzzle;
	skSolver* mySolver;

	btnData stack[256]; //2FIX
	int stack_d;

};

#endif // _KSUDOKUVIEW_H_
