/*
	mmainwindow.h - The main window
	Copyright (C) 2003  Konrad Twardowski <kdtonline@poczta.onet.pl>

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __MMAINWINDOW_H__
#define __MMAINWINDOW_H__

#include "actions.h"
#include "kshutdowniface.h"

#include <qdatetime.h>

#include <kmainwindow.h>

class AppObserver;
class MMessageDialog;
class MStatsTab;

class QDateTimeEdit;
class QLabel;

class KPushButton;

#define ks_main MMainWindow::getInstance()

/** @short The main window. */
class MMainWindow: public KMainWindow, virtual public KShutdownIface
{
	Q_OBJECT
public:
	/**
	 * Timeout options.
	 */
	enum DelayType {
		DelayType_Now = 0, /**< Immediate action (no delay). */
		DelayType_TimeFromNow = 1, /**< Time from now in HH:MM format. */
		DelayType_DateTime = 2, /**< Absolute date and time. */
		DelayType_OnAppExit = 3 /**< When desired application exit. */
	};

	/** Constructor. */
	MMainWindow();

	/** Destructor. */
	virtual ~MMainWindow();

	/** Sets current action to @p action. */
	void setAction(const Action::Type action);

	/** Sets delay type to @p value. */
	void setDelayType(const DelayType value);

	/** Sets editor time to @p time. */
	void setTime(const QTime &time);

	/** Returns the main window widget. Accessed via the @c ks_main macro. */
	inline static MMainWindow *getInstance() { return _instance; }

	/**
	 * Creates and shows a modal warning message dialog.
	 * @param timeout A timeout in seconds
	 */
	void messageDialog(const int timeout);

	/** Sets editor date to @p date. */
	void setDate(const QDate &date);

	/**
	 * Activates the selected action.
	 * @param confirmation @c false - no confirmation
	 */
	void start(const bool confirmation = true);

	// DCOP:
	// general:
	virtual void cancel();
	virtual bool shutDown();
	virtual bool shutdown();
	virtual bool reboot();
	virtual bool lockScreen();
	virtual bool logout();
	// misc:
	virtual void configure();
	virtual QString getStatusInfo();
	virtual void makeVisible();
	virtual void setTestMode(bool yes);
private:
	int _oldSec;
	AppObserver *_appObserver;
	QDateTimeEdit *_dateTimeEdit;
	KPushButton *b_startStop;
	MMessageDialog *_messageDialog;

	// points to the main window widget (this)
	static MMainWindow *_instance;
	MStatsTab *_stats;
	QComboBox
		*cb_actions,
		*cb_delayTypes;
	QDateTime
		dt_end, // end date/time
		dt_start; // start date/time
	QLabel *l_statusLine;
	QTimer *_timer; // timeout timer
	DelayType _delayType;
	void calcSelectedTime();
	void initMainMenu();
	QWidget *initWidgets();

	/**
	 * Sets window and system tray captions.
	 * @param remainingTime A remaining time
	 * @param selectedTime A selected time
	 */
	void setCaptions(const QString &remainingTime = QString::null, const QString &selectedTime = QString::null);

	void setWidgetsEnabled(const bool yes);

	/**
	 * Updates time infos (e.g. window captions).
	 * Displays time to the final shut down, and the selected action name.
	 */
	void updateTimeInfo(const int secs);
private slots:
	/**
	 * This signal is emitted when the application is about to quit, or when the
	 * user shuts down the entire desktop session.
	 */
	void slotAboutToQuit();

	/**
	 * Checks the time, and after timeout executes active action.
	 */
	void slotCheckTime();

	/**
	 * Called when a new item has been selected in the combo box.
	 * @param index A new item index
	 */
	void slotDelayTypeChange(int index);

	/** Displays the settings dialog. */
	void slotConfigure();
	void slotConfigureNotifications();

	void slotActionChange(int index);
	void slotCheckSystemConfig();
	void slotStartStop();
	void slotStats();

	/**
	 * Updates "Selected time:" info.
	 * @see calcSelectedTime
	 */
	void slotUpdateTimeInfo();
public slots:
	/** Cancels an active action. */
	void slotCancel();
	/** Quits the application. */
	void slotQuit();
protected:
	/** Closes or minizes the main window. */
	virtual bool queryClose();
	/**
	 * Invoked at application exit.
	 * @return @c true
	 */
	virtual bool queryExit();
};

#endif // __MMAINWINDOW_H__
