/***************************************************************************
                          LMSensors.h  -  description
                             -------------------
    begin                : Mon Aug 6 2001
    copyright            : (C) 2001 by Miguel Novas
    email                : michaell@teleline.es
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef LMSensors_H
#define LMSensors_H

#include <qobject.h>
#include <qobjcoll.h>
#include <kconfig.h>
#include <qstringlist.h>

#include <sensors/sensors.h>

#include "lmsensor.h"

/**
  *@author Michael
  */

class LMSensors : public QObject
{
Q_OBJECT

  friend class LMSensor;

public:

  enum TempScale { dgCelsius, dgFahrenheit, dgKelvin };


	LMSensors(KConfig *cfg=0, QObject *parent=0, const char *name=0);
	~LMSensors();

  void setMonitorized(bool enable);
  QObjectList *getSensors()               { return (QObjectList *)children(); };
  LMSensor *getSensor(int index)          { return (LMSensor *)((QObjectList *)children())->at(index); }
  LMSensor *getSensor(const char *name)   { return (LMSensor *)child(name); }
  int count() 									          { return children()->count(); }

  void      setTempScale(TempScale scale);
  TempScale getTempScale()                { return tempScale; }

  void setUpdateInterval(int seconds);
  int  getUpdateInterval()                {  return updateInterval/1000; }

  KConfig *getConfig()                    { return ksConfig;  }

  void readConfig();
  void writeConfig();

signals:

  void valueChanged(LMSensor *);
  void configChanged(LMSensor *);

protected slots:

  void slotValueChanged(double value);

protected:

  const sensors_chip_name *getChipName();
  static const char *getSensorPrintMask(int sensorType, bool addSufix=false, TempScale temp= dgCelsius);

private:

  bool monitorized;
  int  updateInterval;
  KConfig *ksConfig;
  const sensors_chip_name *chip_name;
  TempScale tempScale;

  bool initSensorsChip();
  int  getSensorId(const char *sensor_name);
  void createSensors();
  void timerEvent( QTimerEvent * );
};

#endif
