/***************************************************************************
                          mydirplugin.cpp  -  description
                             -------------------
    begin                : Tue Jan 29 2002
    copyright            : (C) 2002 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// Own includes
#include "mydirplugin.h"

// KDE includes
#include <kapplication.h>
#include <kiconloader.h>
#include <kfiledialog.h>
#include <klocale.h>

// QT includes
#include <qlabel.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qgroupbox.h>
#include <qspinbox.h>

const QString MyDirPlugin::getName() const
{
    return i18n("Dir Plugin");
}

const QString MyDirPlugin::getAccelName() const
{
    return i18n("&Dir Plugin");
}

const int MyDirPlugin::type() const
{
    return TYPE_FINAL_FILE;
}

bool MyDirPlugin::checkError()
{
    return true;
}

const QPixmap MyDirPlugin::getIcon() const
{
    return kapp->iconLoader()->loadIcon( "folder", KIcon::Small );
}

void MyDirPlugin::drawInterface( QWidget* w, QVBoxLayout* l )
{
    QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    QSpacerItem* spacer2 = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );

    QVBoxLayout* LayoutA = new QVBoxLayout( 0, 6, 6 );
    QVBoxLayout* LayoutB = new QVBoxLayout( 0, 6, 6 );

    QLabel* la = new QLabel( w );
    la->setText( i18n("<qt>This plugin sorts files after renaming in subdirectories.</qt>") );
    l->addWidget( la );

    groupNumber = new QGroupBox( w );
    groupNumber->setTitle( i18n( "&Options" ) );
    groupNumber->setColumnLayout(0, Qt::Vertical );
    groupNumber->layout()->setSpacing( 6 );
    groupNumber->layout()->setMargin( 11 );
    groupNumberLayout = new QHBoxLayout( groupNumber->layout() );
    groupNumberLayout->setAlignment( Qt::AlignTop );

    QLabel* la2 = new QLabel( groupNumber );
    la2->setText( i18n( "Files per directory:" ) );

    spinFiles = new QSpinBox( groupNumber );
    spinFiles->setRange( 1, 60000 );
    spinFiles->setValue( 10 );

    QLabel* la3 = new QLabel( groupNumber );
    la3->setText( i18n( "Start index:" ) );

    spinStart = new QSpinBox( groupNumber );
    spinFiles->setRange( 0, 60000 );

    LayoutA->addWidget( la2 );
    LayoutA->addWidget( la3 );
    LayoutB->addWidget( spinFiles );
    LayoutB->addWidget( spinStart );

    groupNumberLayout->addLayout( LayoutA );
    groupNumberLayout->addLayout( LayoutB );
    groupNumberLayout->addItem( spacer );

    groupOutput = new QGroupBox( w );
    groupOutput->setTitle( i18n( "Output &Directory" ) );
    groupOutput->setColumnLayout(0, Qt::Vertical );
    groupOutput->layout()->setSpacing( 6 );
    groupOutput->layout()->setMargin( 11 );
    groupOutputLayout = new QHBoxLayout( groupOutput->layout() );
    groupOutputLayout->setAlignment( Qt::AlignTop );

    outputdir = new QLineEdit( groupOutput );
    buttonDir = new QPushButton( groupOutput );
    buttonDir->setText( "..." );

    groupOutputLayout->addWidget( outputdir );
    groupOutputLayout->addWidget( buttonDir );

    l->addWidget( groupNumber );
    l->addWidget( groupOutput );
    l->addItem( spacer2 );

    connect( buttonDir, SIGNAL(clicked()), this, SLOT(chooseDir()));
}

void MyDirPlugin::fillStructure()
{
    fpd = spinFiles->value();
    fpd--;
    dir = outputdir->text();

    filecounter = 0;
    dircounter = spinStart->value();
    curdir = dir +  QString("/%1/").arg( dircounter );

    d = new QDir( dir );
    d->mkdir( curdir );
}

QString MyDirPlugin::processFile( BatchRenamer*, int, QString token, int )
{
    QString newname;
    // token = filename
    if( filecounter == fpd ) {
        filecounter = 0;
        dircounter++;
        curdir = dir +  QString("/%1/").arg( dircounter );
        d->mkdir( curdir );
    }

    QFileInfo f( token );
    newname = curdir + f.fileName();
    d->rename( token, newname );
    filecounter++;
    return QString::null;
}

void MyDirPlugin::finished()
{
    filecounter = dircounter = 0;
}

void MyDirPlugin::chooseDir()
{
    QString s (KFileDialog::getExistingDirectory ( QString::null ));
    if(!s.isEmpty())
        outputdir->setText( s );
}

