// KreateCD - CD recording software for the K desktop environment
//
// 2001 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General      
// Public License.  See the file COPYING in the main directory of the       
// KreateCD distribution for more details.                                     

#include "WavIdentify.h"

int WavIdentify::identify(void) {
  char string[6];
  long int filesize,chunksize;
  int hasformat=0,hasdata=0;
  long int wavformat,wavchannels,wavalign,wavsamsize;
  long int wavaverage,wavrate;
  long int datapos=0,datasize=0;

  resetFile();
  if (!readString(string,4)) return(0);
  string[5]=0;
  if (strCompare(string,"RIFF",4)!=0) return(0);
  if (!readLELong(&filesize)) return(0);
  if (!readString(string,4)) return(0);
  if (strCompare(string,"WAVE",4)!=0) return(0);
  filesize-=4;
  while (1) {
    if ( (hasformat) && (hasdata) ) break;
    if (filesize==0) break;
    if (filesize<8) {
      return(0);
    }
    if (!readString(string,4)) return(0);
    if (!readLELong(&chunksize)) return(0);
    filesize-=8;
    if (filesize<chunksize) {
      return(0);
    }
    filesize-=chunksize;
    if (strCompare(string,"fmt ",4)==0) {
      if (chunksize<16) return(0);
      hasformat=1;
      if (!readLEShort(&wavformat)) return(0);
      if (!readLEShort(&wavchannels)) return(0);
      if (!readLELong(&wavrate)) return(0);
      if (!readLELong(&wavaverage)) return(0);
      if (!readLEShort(&wavalign)) return(0);
      if (!readLEShort(&wavsamsize)) return(0);
      if (chunksize>16) {
        if (!skipRead(chunksize-16)) return(0);
      }
    } else {
      if (strCompare(string,"data",4)==0) {
        datapos=getPosition();
        datasize=chunksize;
        hasdata=1;
        if (!skipRead(chunksize)) return(0);
      } else {
        if (!skipRead(chunksize)) return(0);

      }
    }
  }
  if ( (!hasformat) || (!hasdata)) return(0);
  switch (wavformat) {
  case 1: //WAVE_FORMAT_PCM
    setSampleFormat(AudioIdentify::Samples_PCM);
    break;
  case 0x6: //WAVE_FORMAT_ALAW
    setSampleFormat(AudioIdentify::Samples_ALaw);
    break;
  case 0x7: //WAVE_FORMAT_MULAW
    setSampleFormat(AudioIdentify::Samples_ULaw);
    break;

  case 0: //WAVE_FORMAT_UNKNOWN
  case 0x2: //WAVE_FORMAT_ADPCM
  case 0x10: //WAVE_FORMAT_OKI_ADPCM
  case 0x15: //WAVE_FORMAT_DIGISTD
  case 0x16: //WAVE_FORMAT_DIGIFIX
  case 0x101: //IBM_FORMAT_MULAW
  case 0x102: //IBM_FORMAT_ALAW
  default:
    return(0);

  }
  switch (wavsamsize) {
  case 8:
    setSampleSize(AudioIdentify::Samples_8Bit);
    if (wavformat==1) {
      setSampleFormat(AudioIdentify::Samples_PCM_Unsigned);
    }
    break;
  case 16:
    if ( (wavformat==6) || (wavformat==7) ) return(0);
    setSampleSize(AudioIdentify::Samples_16Bit);
    break;
  case 32:
    if ( (wavformat==6) || (wavformat==7) ) return(0);
    setSampleSize(AudioIdentify::Samples_32Bit);
    break;
  default:
    return(0);
  }
  setSampleEndian(AudioIdentify::Endian_Little);
  setSampleChannels(wavchannels);
  setSampleRate(wavrate);
  setDataPos(datapos);
  setDataSize(datasize);
  if ( (sampleChannels()<=0 ) || 
       (sampleRate()<=0) || (dataSize()==0)) {
    return(0);
  }
  setName("MS Windows WAV");
  return(1); 
}
