// KreateCD - CD recording software for the K desktop environment
//
// 2001 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General      
// Public License.  See the file COPYING in the main directory of the       
// KreateCD distribution for more details.                                     

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "VorbisIdentify.h"
#include "VorbisConverter.h"

#include <vorbis/vorbisfile.h>
#include <stdio.h>

int VorbisIdentify::identify(void) {
  OggVorbis_File vf;
  vorbis_info *vi;

  FILE *fil;
  int rc;
  long int pcmsize;

  resetFile();
  fil=fdopen(getFileDescriptor(),"r");
  if (fil==0) return(0);
  rc= ov_open(fil,&vf,NULL,0);
  if (rc<0) return(0);

  pcmsize=ov_pcm_total(&vf,-1);
  if (pcmsize%2352!=0) {
    pcmsize+= (2352-pcmsize%2352);
  }

  vi=ov_info(&vf,-1);
  if (vi==0) {
    ov_clear(&vf);
    return(0);
  }

  setSampleFormat(AudioIdentify::Samples_PCM);
  setSampleSize(AudioIdentify::Samples_16Bit);
  setSampleEndian(AudioIdentify::Endian_Big);
  setSampleChannels(vi->channels);
  setSampleRate(vi->rate);
  setDataPos(0);
  setDataSize(pcmsize*2*vi->channels);
  setName("Ogg vorbis file");
  setConverter(new VorbisConverter(),VorbisConverter::vorbisDecoder);
 
  ov_clear(&vf);
 
  return(1);
} 
  
