// KreateCD - CD recording software for the K desktop environment
//
// 1999-2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General      
// Public License.  See the file COPYING in the main directory of the       
// KreateCD distribution for more details.                                     

#include "LineDialog.h"

#include <klineedit.h>

#include <qlayout.h>
#include <qwindowdefs.h>
#include <qstring.h>
#include <klocale.h>

#include "LineDialog.moc"

LineDialog::LineDialog( QWidget *parent, const char *name,
			const char *startstring)
  :KDialogBase( parent,name, true, 
		i18n("Enter dirname"), Ok|Cancel, Ok, true) {

  /*
  QVBoxLayout *qlay;

  qlay=new QVBoxLayout(this);*/

  EditWidget=new KLineEdit(this,0);
  EditWidget->setText(startstring);
  {
    QSize qsiz;
    qsiz=EditWidget->sizeHint();
    EditWidget->setFixedHeight(qsiz.height());

  }
  //  qlay->addWidget(EditWidget);
  connect(EditWidget,SIGNAL(returnPressed()),
          this,SLOT(leaveDialog()));

  EditWidget->setFocus();
  setMainWidget(EditWidget);
  //  qlay->activate();
}

LineDialog::~LineDialog(void) {
}


void LineDialog::leaveDialog(void) {
  if (EditWidget->text().isEmpty())
    done(0);
  else
    done(1);
}

const char *LineDialog::getInput(void) {
  return(EditWidget->text());
}
