// KreateCD - CD recording software for the K desktop environment
//
// 2000 by Joseph Wenninger <jowenn@bigfoot.com>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#include "ConfigProjectType.h"
#include "ConfigProjectType.moc"

#include <qvbuttongroup.h>
#include <qlayout.h>
#include <klocale.h>
#include <kdialog.h>
#include <qlabel.h>
#include <qwhatsthis.h>
#include <kapp.h>
#include <kconfig.h>

ConfigProjectType::ConfigProjectType( QWidget *parent, const char *name )
  : QWidget(parent,name) {
  //CODE
  for (int i=0;i<TLMMaxTypeCount;i++) List[i]=0;
  QVBoxLayout *layout=new QVBoxLayout(this,0,KDialog::spacingHint());

  QVButtonGroup *btngrp=new QVButtonGroup(i18n("Project types:"),this);
  btngrp->setExclusive(true);
  for (int i=0; ProjectTypeNames[i]!=0;i++) {
    List[i]=new QRadioButton(i18n(ProjectTypeNames[i]),btngrp);
  }
  QWhatsThis::add(btngrp,i18n("The chosen project type will be selected by default in the <I>New Project</I> dialog. You only need to hit enter to create a new project of that type then"));

  layout->addWidget(btngrp,0,AlignCenter);

  layout->addWidget(bypass=new QCheckBox(i18n("Bypass startup dialog"),this),0,AlignLeft);
  QWhatsThis::add(bypass,i18n("If you activate this option the <I>New Project</I> dialog will not be shown on startup and a new project of the chosen default type will be created"));
  KConfig *config=kapp->config();
  config->setGroup("Project");
  bypass->setChecked(!((config->readEntry("StartupType")).isEmpty()));


  QString sid=config->readEntry("DefaultType");
  int iid;
  if (sid.isNull()) List[0]->setChecked(true);
  else {
    iid=sid.toInt();
    if ((iid>=0) && (iid<TLMMaxTypeCount)) {
      //for further extension:	  if (List[iid]!=0) List[iid]->setChecked(true); else List[0]->setChecked(true);
      List[iid]->setChecked(true);  
    } else List[0]->setChecked(true);
  }
  layout->addStretch();
}

ConfigProjectType::~ConfigProjectType() {
}

void ConfigProjectType::applySettings() {
  KConfig *config=kapp->config();
  config->setGroup("Project");
  int res=-1;
  for (int i=0;(i<TLMMaxTypeCount);i++)
    if (List[i]->isChecked()) {res=i; break;}
  config->writeEntry("DefaultType",QString("%1").arg(res));
  if (bypass->isChecked())
    config->writeEntry("StartupType",QString("%1").arg(res));
  else
    config->writeEntry("StartupType","");
}

