// KreateCD - CD recording software for the K desktop environment
//
// 2000 by Niels Reedijk <nielx@kde.nl>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#include "ConfigDialog.h"
#include "ConfigPathWidget.h"
#include "ConfigSCSIWidget.h"
#include "IsoOptions.h"
#include "ConfigProjectType.h"
#include "ConfigBurnerWidget.h"

#include <qwidget.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>

#include <klocale.h>
#include <kconfig.h>
#include <kapp.h>
#include <kiconloader.h>
#include <qvbox.h>

#include "ConfigDialog.moc"

ConfigDialog::ConfigDialog( QWidget *parent , const char *name )
  : KDialogBase( IconList ,                //SetfaceIconlist
		 i18n( "Configuration" ) , //Title
		 Ok|Apply|Cancel ,         //Buttons
		 Ok ,                      //MainButton
		 parent ,                  //Parent
		 name ,                    //name
		 true ,                    //Dialog is modal
		 true )                    //Draw a separator between buttons and widget

{
  KConfig *config;

  QRect DefaultRect(100,50,500,300);
  config=kapp->config();
  setIconListAllVisible( true );

  //The Path Widget
  QFrame *theConfigPathWidgetPage = addPage( i18n( "Please do not forget the leading and following spaces." , "    Paths    " ) ,
                                             i18n( "Path settings" ) ,
                                             KGlobal::instance()->iconLoader()->loadIcon( "find" ,
											  KIcon::NoGroup , KIcon::SizeMedium ) );

  QVBoxLayout *theConfigPathWidgetLayout = new QVBoxLayout( theConfigPathWidgetPage );
  theConfigPathWidget = new ConfigPathWidget( theConfigPathWidgetPage , "theConfigPathWidget" );
  theConfigPathWidgetLayout->addWidget( theConfigPathWidget );

  //The SCSI Widget
  QFrame *theConfigSCSIWidgetPage = addPage( i18n ( "SCSI" ) ,
                                             i18n( "SCSI settings" ) ,
                                             KGlobal::instance()->iconLoader()->loadIcon( "kcmscsi" ,
											  KIcon::NoGroup , KIcon::SizeMedium ) );
  QVBoxLayout *theConfigSCSIWidgetLayout = new QVBoxLayout( theConfigSCSIWidgetPage );
  theConfigSCSIWidget = new ConfigSCSIWidget( theConfigSCSIWidgetPage , "theConfigSCSIWidget" );
  theConfigSCSIWidgetLayout->addWidget( theConfigSCSIWidget );

  //The ISO Options Widget
  QFrame *theISOOptionsPage = addPage( i18n( "ISO defaults" ) ,
				       i18n( "Default ISO settings" ) ,
				       KGlobal::instance()->iconLoader()->loadIcon( "cdrom_unmount" ,
										    KIcon::NoGroup , KIcon::SizeMedium ) );
  QVBoxLayout *theISOOptionsLayout = new QVBoxLayout( theISOOptionsPage );
  theISOOptions = new ISOOptions( theISOOptionsPage , "theISOOptions" );
  theISOOptionsLayout->addWidget( theISOOptions );

  //The Burner Widget
  QFrame *theConfigBurnerWidgetPage = addPage( i18n( "Burner" ) ,
                                         i18n( "Burner Settings" ) ,
                                         KGlobal::instance()->iconLoader()->loadIcon( "cdwriter_unmount" ,
                                                  KIcon::NoGroup , KIcon::SizeMedium ) );
  QVBoxLayout *theConfigBurnerWidgetLayout = new QVBoxLayout ( theConfigBurnerWidgetPage );
  theConfigBurnerWidget = new ConfigBurnerWidget( theConfigBurnerWidgetPage , "theConfigBurnerWidget" );
  theConfigBurnerWidgetLayout->addWidget( theConfigBurnerWidget );

  //The Project Type Configuration (by Joseph Wenninger)
  QVBox *theConfigProjectTypePage=addVBoxPage(i18n("Project"), i18n("Default project type"),UserIcon("kcd_projecttype_config.png"));
  theConfigProjectType=new ConfigProjectType(theConfigProjectTypePage,"theProjectTypes");
  //Joseph Wenninger --- END

  this->setButtonTip( Ok , "Applies settings and closes dialog" );
  this->setButtonWhatsThis( Ok , "If you click on this button, all the settings (so the paths, scsi options and iso options) will be saved and this dialog will be closed.");

  this->setButtonTip( Apply , "Applies settings" );
  this->setButtonWhatsThis( Apply , "If you click on this button, all the settings (so the paths, scsi options and iso options) will be saved.");

  this->setButtonTip( Cancel , "Doesn't save settings and closes dialog" );
  this->setButtonWhatsThis( Cancel , "If you click on this button, all the changes to the settings will be discarded and this dialog will be closed.");

  this->setEscapeButton( Cancel );

  config->setGroup( "Geometry" );
  this->setGeometry(config->readRectEntry( "ConfigDialogGeometry" , &DefaultRect ) );
}

ConfigDialog::~ConfigDialog() {
  KConfig *config;
  QRect SaveRect(this->pos(),this->size());
  config=kapp->config();
  config->setGroup("Geometry");
  config->writeEntry("ConfigDialogGeometry",SaveRect);
}

void ConfigDialog::hide() {
  emit closed();
  KDialogBase::hide();
}

void ConfigDialog::slotOk() {
  this->slotApply();
  this->hide();
}

void ConfigDialog::slotApply() {
  KConfig *config;

  theConfigPathWidget->applySettings();
  theConfigSCSIWidget->applySettings();
  theISOOptions->applySettings();
  theConfigProjectType->applySettings();
  theConfigBurnerWidget->applySettings();
  config=kapp->config();
  config->sync();
}

void ConfigDialog::slotCancel() {
  this->hide();
}
