// KreateCD - CD recording software for the K desktop environment
//
// 2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#ifndef CHOOSEDIALOG_INCLUDED
#define CHOOSEDIALOG_INCLUDED

#include <qwidget.h>
#include <qdialog.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qbuttongroup.h>

class ChooseDialog : public QDialog {
  Q_OBJECT
    public:
  ChooseDialog(const char *caption=0,const char *headertext=0, QWidget *parent=0, const char *name=0);
  ~ChooseDialog(void);

  void addButton(const char *buttontext);


 protected:
  QButtonGroup *buttonGroup;
  QLabel *headingText;
  QVBoxLayout *buttonLayout;

  int selectedButton;
  int buttonHeight;
  bool doCheck;

  protected slots:
    void newSelected(int selection);
  void okButton(void);
};

#endif
