// KreateCD - CD recording software for the K desktop environment
//
// 1999-2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "AudioRipper.h"
#include "AudioRipper.moc"

#include <kapp.h>
#include <klocale.h>
#include <kprocess.h>

#include <qmessagebox.h>

#include <stdio.h>
#include <string.h>

bool AudioRipper::ripAudio(int track,const char *filename) {
  char progressline[64];

  prepareProcess();
  trackSize=999999;
 
  strcpy(imageFilename,filename);

  if (!doRip(track,imageFilename)) {
    closeProcess();
    return(false);
  }

  sprintf(progressline,i18n("Extracting audio track %d from CD..."),track);
  reportAction(progressline);

  ripflag=0;

  startProcess();
  return(true);
}

int AudioRipper::processCleanup(int retval) {
  if (retval!=1) remove(imageFilename);
  if (retval==-2) {
    QMessageBox::critical(0,QString::null,i18n("Unable to read audio track!"));
  }

  closeProcess();
  if (retval!=1) return(0);

  return(1);
}


void AudioRipper::startTrack(long int size) {
  trackSize=size;
  reportProgress(0,trackSize);
}

void AudioRipper::setPosition(long int pos) {
  reportProgress(pos,trackSize);
}

bool AudioRipper::doRip(int ,const char *) {
  return(false);
}

int AudioRipper::processExited(void) {
  return(ripflag?1:-2);
}
