/***************************************************************************
                          kpregview.h  -  description
                             -------------------
    begin                : Seg Jul 30 00:39:14 EDT 2001
    copyright          : (C) 2001-2003 by Huberto Gastal Mayer
    email                : beto@debian-rs.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KPREGVIEW_H
#define KPREGVIEW_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for Qt
#include <qwidget.h>
#include <qobject.h>
#include <qlabel.h>
#include <qstring.h>
#include <qlistbox.h>
#include <qclipboard.h>
#include <qfile.h>
#include <qtextstream.h>
#include <qdir.h>
#include <qdom.h>
//#include <ktabwidget.h>
#include <qtabwidget.h>
#include <qptrlist.h>

// include files for KDE
#include <kstddirs.h>
#include <kpopupmenu.h>
#include "kpreglistbox.h"
#include "itemxmlfactory.h"

/** The KpregView class provides the view widget for the KpregApp instance.
 * The View instance inherits QWidget as a base class and represents the view object of a KTMainWindow. As KpregView is part of the
 * docuement-view model, it needs a reference to the document object connected with it by the KpregApp class to manipulate and display
 * the document structure provided by the KpregDoc class.
 *
 * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
 * @version KDevelop version 0.4 code generation
 */
class KpregView : public QWidget
{
  Q_OBJECT
  public:
	KpregView(QWidget *parent = 0, const char *name=0);
	~KpregView();

	KpregItem* editItem ();
	KpregListBox *editCategory ();
	QDomDocumentFragment save (QDomDocument);
	void setAtSysTray (bool);
	bool saveModified();
	void setModified(bool _m=true);
	bool isModified(){ return modified; };
	void setHierMenu(KPopupMenu*);
	void clearItens();

signals:
	void save_all();
	void setSaveButtonEnabled(bool);
	void currentCategoryMenu (KPopupMenu*);

public slots:
	void deleteItem ();
	void deleteCategory ();
	void moveItemUp ();
	void moveItemDown ();
	void moveCategoryRight();
	void moveCategoryLeft();
	void slotAddItem ( QDomDocument );
	void insertNewTab (QDomDocument);
	void insertNewTab (QDomNode);
	void changedCategory ();
	void copyItem ();
	void cutItem ();
	void pasteItens ( Position pos=end );

protected:
	virtual  void resizeEvent ( QResizeEvent * );

private:

	QPtrList<KpregListBox> kplb_list;
	bool modified;
	bool atualizeSysTray;
	QString *str_file;
//	KTabWidget *qtw;
	QTabWidget *qtw;
	KPopupMenu *hierMenu;
	QPixmap *blue_pm;
	QPixmap *red_pm;
	QPixmap *yellow_pm;
	KpregItem *copiedItem;
};

#endif // KPREGVIEW_H
