//
// C++ Implementation: kpogrecomboaction
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpogrecomboaction.h"

// include files for QT
#include <qwhatsthis.h>
#include <qdragobject.h>
#include <qcombobox.h>
#include <qapplication.h>

// include files for KDE
#include <ktoolbar.h>
#include <kiconloader.h>
#include <kmimetype.h>
#include <kdebug.h>

KPoGreComboAction::KPoGreComboAction(const QString& text,
                                             int accel,
                                             const QObject *receiver,
                                             const char *member,
                                             QObject* parent,
                                             const char* name)
 : KAction(text, accel, parent, name),
      m_pCombo(0)
{
	m_receiver = receiver;
  m_member = member;
}


KPoGreComboAction::~KPoGreComboAction()
{
}

QComboBox* KPoGreComboAction::comboBox()
{
 	return m_pCombo;
}

int KPoGreComboAction::plug(QWidget *w, int index)
{
  //  if ( !w->inherits( "KToolBar" ) );
  //    return -1;

  KToolBar *toolBar = (KToolBar *) w;

  int id = KAction::getToolButtonID();
  //kdDebug() << "KPoGreComboAction::plug id=" << id << endl;

  m_pCombo = new QComboBox( toolBar, "Path Combo" );
  m_pCombo->setEditable(true);
  m_pCombo->setInsertionPolicy(QComboBox::NoInsertion);
  toolBar->insertWidget( id, 70, m_pCombo, index );
  connect( m_pCombo, SIGNAL(activated(const QString&)), m_receiver, m_member );

  addContainer( toolBar, id );

  connect(toolBar, SIGNAL(destroyed()), this, SLOT(slotDestroyed()));

  toolBar->setItemAutoSized(id, true);

  QWhatsThis::add( m_pCombo, whatsThis() );

  return containerCount() - 1;
}

void KPoGreComboAction::unplug(QWidget *w)
{
//  if ( !w->inherits( "KToolBar" ) )
//    return;

  KToolBar *toolBar = (KToolBar *)w;

  int idx = findContainer( w );
  //kdDebug() << "KPoGreComboAction::unplug idx=" << idx << " menuId=" << menuId(idx) << endl;

  toolBar->removeItem( menuId( idx ) );

  removeContainer( idx );
  m_pCombo = 0;
}

void KPoGreComboAction::slotClear()
{
  if ( containerCount() == 0 )
  {
    kdWarning() << "KPoGreComboAction::slotClear action not plugged" << endl;
    return;
  }

  m_pCombo->clear();
}

void KPoGreComboAction::slotClearEdit()
{
  if ( containerCount() == 0 )
  {
    kdWarning() << "KPoGreComboAction::slotClearEdit action not plugged" << endl;
    return;
  }

  m_pCombo->clearEdit();
}

void KPoGreComboAction::slotFocusEdit()
{
  if ( containerCount() == 0 )
  {
    kdWarning() << "KPoGreComboAction::slotFocusEdit action not plugged" << endl;
    return;
  }

  m_pCombo->setFocus();
}

QString KPoGreComboAction::currentText() const
{
  if ( containerCount() == 0 )
  {
    kdWarning() << "KPoGreComboAction::currentText action not plugged" << endl;
    return QString::null;
  }

  return m_pCombo->currentText();
}

const QPixmap * KPoGreComboAction::currentPixmap() const
{
  if ( containerCount() == 0 )
  {
    kdWarning() << "KPoGreComboAction::currentPixmap action not plugged" << endl;
    return 0;
  }

  return m_pCombo->pixmap( m_pCombo->currentItem() );
}

void KPoGreComboAction::insertItem( const QPixmap & pixmap, const QString & text )
{
  if ( containerCount() == 0 )
  {
    kdWarning() << "KPoGreComboAction::insertItem action not plugged" << endl;
    return;
  }

	if ( text.isEmpty() )
    kdWarning() << "KPoGreComboAction::insertItem empty string as parameter" << endl;

  int nIndex = findItem(text);
  if ( nIndex != -1 )
    m_pCombo->removeItem(nIndex);

  m_pCombo->insertItem( pixmap, text, 0 );
  m_pCombo->setCurrentItem(0);

  if ( m_pCombo->count() > 15 ) // max 15 item in path combo
    m_pCombo->removeItem(15);
}

void KPoGreComboAction::removeItem( const QString & text )
{
  if ( containerCount() == 0 )
  {
    kdWarning() << "KPoGreComboAction::removeItem action not plugged" << endl;
    return;
  }

  int nIndex = findItem(text);
  if ( nIndex == -1 )
  {
    kdDebug() << "KPoGreComboAction::removeItem item not found" << endl;
    return;
  }

  m_pCombo->removeItem(nIndex);
}

int KPoGreComboAction::findItem( const QString & text )
{
  if ( containerCount() == 0 )
  {
    kdWarning() << "[KPoGreComboAction::findItem] action not plugged" << endl;
    return -1;
  }

  int nIndex = -1;
  int i=0;
  while ( ( i < m_pCombo->count() ) && ( nIndex == -1 ) )
  {
    if ( m_pCombo->text(i) == text )
      nIndex = i;
    i++;
  }

  return nIndex;
}

ToolbarLabel::ToolbarLabel(  const QString& text )
  : QLabel( text, 0L, "kde toolbar widget" )	// Use this name for it to be styled!
{
  setBackgroundMode( Qt::PaletteButton );
  setAlignment( (QApplication::reverseLayout() ? Qt::AlignRight : Qt::AlignLeft) |
                 Qt::AlignVCenter | Qt::ShowPrefix );
  adjustSize();
}


#include "kpogrecomboaction.moc"
