/***************************************************************************
                          kpgbookmarkhandler.h  -  description
                             -------------------
    begin                : Ne led 25 2004
    copyright            : (C) 2004 by Lumir Vanek
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KPGBOOKMARKHANDLER_H
#define KPGBOOKMARKHANDLER_H

#include "kbookmarkmanager.h"

#include <qobject.h>
  
class KPopupMenu;
class KActionMenu;
class KPGBookmarkMenu;

/** 
  * Bookmark handler, for list of registered servers
  * 
  * @author Lumir Vanek
  */
class KPGBookmarkHandler : public QObject, public KBookmarkOwner
{
	Q_OBJECT

public:
  KPGBookmarkHandler( QWidget* parent, KPopupMenu *kpopupmenu=0 );
  ~KPGBookmarkHandler();
  
  void setNewBookmarkName(const QString strNewBookmarkName) { m_strNewBookmarkName = strNewBookmarkName; }
  void setNewBookmarkUrl(const QString strNewBookmarkUrl) { m_strNewBookmarkUrl = strNewBookmarkUrl; }

  /**
   * This function is called when the user selects a bookmark.
  */
  virtual void openBookmarkURL( const QString& url );

  /**
   * This method is called whenever the user wants to add the
   * current location to the bookmarks list. It is called
   * after currentURL().
   *
   * @returns QString that will become the name of the bookmark.
  */
  virtual QString currentTitle() const;

  /**
   * This method is called whenever the user wants to add the
   * current location to the bookmarks list.
   * It is called before currentTitle().
   *
   * @returns QString that will become the URL of the bookmark.
  */
  virtual QString currentURL() const;
  
  // Enables / disables new bookmark menu
  void enableAddBookmarkMenu(bool);

  KPGBookmarkMenu *menu() const { return m_pBookmarkMenu; }

signals:
  void openUrl(const QString& url );

protected:

  QWidget *mParent;
  KPGBookmarkMenu *m_pBookmarkMenu;

  QString m_strNewBookmarkName;
  QString m_strNewBookmarkUrl;
};

#endif
